/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.common.AbstractJoinNode;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.core.impl.util.FieldBasedScalingMap;

public abstract class AbstractUnindexedJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_>
extends AbstractJoinNode<LeftTuple_, Right_, OutTuple_, MutableOutTuple_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Map<LeftTuple_, Map<UniTuple<Right_>, MutableOutTuple_>> leftToRightMap = new LinkedHashMap<LeftTuple_, Map<UniTuple<Right_>, MutableOutTuple_>>();
    private final Set<UniTuple<Right_>> rightSet = new LinkedHashSet<UniTuple<Right_>>();

    protected AbstractUnindexedJoinNode(TupleLifecycle<OutTuple_> nextNodesTupleLifecycle) {
        super(nextNodesTupleLifecycle);
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        FieldBasedScalingMap outTupleMapLeft = new FieldBasedScalingMap(LinkedHashMap::new);
        this.leftToRightMap.put(leftTuple, (Map<UniTuple<Right_>, MutableOutTuple_>)outTupleMapLeft);
        for (UniTuple<Right_> rightTuple : this.rightSet) {
            this.insertTuple(outTupleMapLeft, leftTuple, rightTuple);
        }
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft = this.leftToRightMap.get(leftTuple);
        if (outTupleMapLeft == null) {
            this.insertLeft(leftTuple);
            return;
        }
        for (Tuple outTuple : outTupleMapLeft.values()) {
            this.updateOutTupleLeft(outTuple, leftTuple);
            this.updateTuple(outTuple);
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft = this.leftToRightMap.remove(leftTuple);
        if (outTupleMapLeft == null) {
            return;
        }
        for (Tuple outTuple : outTupleMapLeft.values()) {
            this.retractTuple(outTuple);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        this.rightSet.add(rightTuple);
        for (Map.Entry<LeftTuple_, Map<UniTuple<Right_>, MutableOutTuple_>> entry : this.leftToRightMap.entrySet()) {
            Tuple leftTuple = (Tuple)entry.getKey();
            Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft = entry.getValue();
            this.insertTuple(outTupleMapLeft, leftTuple, rightTuple);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        if (!this.rightSet.contains(rightTuple)) {
            this.insertRight(rightTuple);
            return;
        }
        for (Map.Entry<LeftTuple_, Map<UniTuple<Right_>, MutableOutTuple_>> entry : this.leftToRightMap.entrySet()) {
            Tuple leftTuple = (Tuple)entry.getKey();
            Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft = entry.getValue();
            Tuple outTuple = (Tuple)outTupleMapLeft.get(rightTuple);
            this.updateOutTupleRight(outTuple, rightTuple);
            if (outTuple == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") has tuples on the right side that didn't exist on the left side.");
            }
            this.updateTuple(outTuple);
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        boolean removed = this.rightSet.remove(rightTuple);
        if (!removed) {
            return;
        }
        for (Map.Entry<LeftTuple_, Map<UniTuple<Right_>, MutableOutTuple_>> entry : this.leftToRightMap.entrySet()) {
            Tuple leftTuple = (Tuple)entry.getKey();
            Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft = entry.getValue();
            Tuple outTuple = (Tuple)outTupleMapLeft.remove(rightTuple);
            if (outTuple == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") has tuples on the right side that didn't exist on the left side.");
            }
            this.retractTuple(outTuple);
        }
    }
}

