/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.function.IntPredicate;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Tuple;

public final class ExistsCounter<Tuple_ extends Tuple> {
    private static final IntPredicate ZERO_COUNT = count -> count == 0;
    private static final IntPredicate NON_ZERO_COUNT = count -> count > 0;
    final Tuple_ leftTuple;
    final IntPredicate alivePredicate;
    BavetTupleState state = BavetTupleState.DEAD;
    int countRight = 0;

    ExistsCounter(Tuple_ leftTuple, boolean shouldExist) {
        this.leftTuple = leftTuple;
        this.alivePredicate = shouldExist ? NON_ZERO_COUNT : ZERO_COUNT;
    }

    boolean isAlive() {
        return this.alivePredicate.test(this.countRight);
    }

    public String toString() {
        return "Counter(" + this.leftTuple + ")";
    }
}

