/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Group;
import org.optaplanner.constraint.streams.bavet.common.GroupPart;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;

public abstract class AbstractGroupNode<InTuple_ extends Tuple, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_, GroupKey_, ResultContainer_, Result_>
extends AbstractNode
implements TupleLifecycle<InTuple_> {
    private final int groupStoreIndex;
    private final Function<InTuple_, GroupKey_> groupKeyFunction;
    private final Supplier<ResultContainer_> supplier;
    private final Function<ResultContainer_, Result_> finisher;
    private final boolean hasMultipleGroups;
    private final boolean hasCollector;
    private final TupleLifecycle<OutTuple_> nextNodesTupleLifecycle;
    private final Map<GroupKey_, Group<MutableOutTuple_, GroupKey_, ResultContainer_>> groupMap;
    private Group<MutableOutTuple_, GroupKey_, ResultContainer_> singletonGroup;
    private final Queue<Group<MutableOutTuple_, GroupKey_, ResultContainer_>> dirtyGroupQueue;

    protected AbstractGroupNode(int groupStoreIndex, Function<InTuple_, GroupKey_> groupKeyFunction, Supplier<ResultContainer_> supplier, Function<ResultContainer_, Result_> finisher, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle) {
        this.groupStoreIndex = groupStoreIndex;
        this.groupKeyFunction = groupKeyFunction;
        this.supplier = supplier;
        this.finisher = finisher;
        this.hasMultipleGroups = groupKeyFunction != null;
        this.hasCollector = supplier != null;
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.groupMap = this.hasMultipleGroups ? new HashMap() : null;
        this.dirtyGroupQueue = new ArrayDeque<Group<MutableOutTuple_, GroupKey_, ResultContainer_>>();
    }

    @Override
    public void insert(InTuple_ tuple) {
        if (tuple.getStore(this.groupStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        GroupKey_ groupKey = this.hasMultipleGroups ? (GroupKey_)this.groupKeyFunction.apply(tuple) : null;
        this.createTuple(tuple, groupKey);
    }

    private void createTuple(InTuple_ tuple, GroupKey_ newGroupKey) {
        Group<MutableOutTuple_, GroupKey_, ResultContainer_> newGroup = this.getOrCreateGroup(newGroupKey);
        ++newGroup.parentCount;
        OutTuple_ outTuple = this.accumulate(tuple, newGroup);
        switch (outTuple.getState()) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.UPDATING);
                this.dirtyGroupQueue.add(newGroup);
                break;
            }
            case DYING: {
                outTuple.setState(BavetTupleState.UPDATING);
                break;
            }
            case ABORTING: {
                outTuple.setState(BavetTupleState.CREATING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The group (" + newGroup + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    private OutTuple_ accumulate(InTuple_ tuple, Group<MutableOutTuple_, GroupKey_, ResultContainer_> group) {
        Runnable undoAccumulator = this.hasCollector ? this.accumulate(group.resultContainer, tuple) : null;
        GroupPart<Group<MutableOutTuple_, GroupKey_, ResultContainer_>> newGroupPart = new GroupPart<Group<MutableOutTuple_, GroupKey_, ResultContainer_>>(group, undoAccumulator);
        tuple.setStore(this.groupStoreIndex, newGroupPart);
        return group.outTuple;
    }

    private Group<MutableOutTuple_, GroupKey_, ResultContainer_> getOrCreateGroup(GroupKey_ key) {
        if (this.hasMultipleGroups) {
            Group<MutableOutTuple_, GroupKey_, ResultContainer_> group = this.groupMap.get(key);
            if (group == null) {
                group = this.createGroup(key);
                this.groupMap.put(key, group);
            }
            return group;
        }
        if (this.singletonGroup == null) {
            this.singletonGroup = this.createGroup(key);
        }
        return this.singletonGroup;
    }

    private Group<MutableOutTuple_, GroupKey_, ResultContainer_> createGroup(GroupKey_ key) {
        MutableOutTuple_ outTuple = this.createOutTuple(key);
        Object resultContainer = this.hasCollector ? (Object)this.supplier.get() : null;
        Group<MutableOutTuple_, GroupKey_, Object> group = new Group<MutableOutTuple_, GroupKey_, Object>(key, resultContainer, outTuple);
        this.dirtyGroupQueue.add(group);
        return group;
    }

    @Override
    public void update(InTuple_ tuple) {
        GroupKey_ newGroupKey;
        GroupPart oldGroupPart = (GroupPart)tuple.getStore(this.groupStoreIndex);
        if (oldGroupPart == null) {
            this.insert(tuple);
            return;
        }
        oldGroupPart.undoAccumulate();
        Group oldGroup = (Group)oldGroupPart.group;
        Object oldGroupKey = oldGroup.groupKey;
        GroupKey_ GroupKey_ = newGroupKey = this.hasMultipleGroups ? (GroupKey_)this.groupKeyFunction.apply(tuple) : null;
        if (Objects.equals(newGroupKey, oldGroupKey)) {
            OutTuple_ outTuple = this.accumulate(tuple, oldGroup);
            switch (outTuple.getState()) {
                case CREATING: 
                case UPDATING: {
                    break;
                }
                case OK: {
                    outTuple.setState(BavetTupleState.UPDATING);
                    this.dirtyGroupQueue.add(oldGroup);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The group (" + oldGroup + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
                }
            }
        } else {
            this.killTuple(oldGroup);
            this.createTuple(tuple, newGroupKey);
        }
    }

    private void killTuple(Group<MutableOutTuple_, GroupKey_, ResultContainer_> group) {
        Object groupKey;
        Group old;
        int newParentCount;
        boolean killGroup;
        boolean bl = killGroup = (newParentCount = --group.parentCount) == 0;
        if (killGroup && (old = this.removeGroup(groupKey = group.groupKey)) == null) {
            throw new IllegalStateException("Impossible state: the group for the groupKey (" + groupKey + ") doesn't exist in the groupMap.");
        }
        Object outTuple = group.outTuple;
        switch (outTuple.getState()) {
            case CREATING: {
                if (!killGroup) break;
                outTuple.setState(BavetTupleState.ABORTING);
                break;
            }
            case UPDATING: {
                if (!killGroup) break;
                outTuple.setState(BavetTupleState.DYING);
                break;
            }
            case OK: {
                outTuple.setState(killGroup ? BavetTupleState.DYING : BavetTupleState.UPDATING);
                this.dirtyGroupQueue.add(group);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The group (" + group + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    private Group<MutableOutTuple_, GroupKey_, ResultContainer_> removeGroup(GroupKey_ groupKey) {
        if (this.hasMultipleGroups) {
            return this.groupMap.remove(groupKey);
        }
        Group<MutableOutTuple_, GroupKey_, ResultContainer_> old = this.singletonGroup;
        this.singletonGroup = null;
        return old;
    }

    @Override
    public void retract(InTuple_ tuple) {
        GroupPart groupPart = (GroupPart)tuple.getStore(this.groupStoreIndex);
        if (groupPart == null) {
            return;
        }
        tuple.setStore(this.groupStoreIndex, null);
        Group group = (Group)groupPart.group;
        groupPart.undoAccumulate();
        this.killTuple(group);
    }

    protected abstract Runnable accumulate(ResultContainer_ var1, InTuple_ var2);

    @Override
    public void calculateScore() {
        block6: for (Group group : this.dirtyGroupQueue) {
            Object outTuple = group.outTuple;
            switch (outTuple.getState()) {
                case CREATING: {
                    this.updateOutTupleToFinisher(outTuple, group.resultContainer);
                    this.nextNodesTupleLifecycle.insert(outTuple);
                    outTuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case UPDATING: {
                    this.updateOutTupleToFinisher(outTuple, group.resultContainer);
                    this.nextNodesTupleLifecycle.update(outTuple);
                    outTuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(outTuple);
                    outTuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
                case ABORTING: {
                    outTuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The group (" + group + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
        }
        this.dirtyGroupQueue.clear();
    }

    protected abstract MutableOutTuple_ createOutTuple(GroupKey_ var1);

    private void updateOutTupleToFinisher(MutableOutTuple_ outTuple, ResultContainer_ resultContainer) {
        if (this.finisher == null) {
            return;
        }
        Result_ result = this.finisher.apply(resultContainer);
        this.updateOutTupleToResult(outTuple, result);
    }

    protected abstract void updateOutTupleToResult(MutableOutTuple_ var1, Result_ var2);
}

