/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.ExistsCounter;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractIfExistsNode<LeftTuple_ extends Tuple, Right_>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    protected final boolean shouldExist;
    private final TupleLifecycle<LeftTuple_> nextNodesTupleLifecycle;
    protected final Queue<ExistsCounter<LeftTuple_>> dirtyCounterQueue;
    protected final boolean isFiltering;

    protected AbstractIfExistsNode(boolean shouldExist, TupleLifecycle<LeftTuple_> nextNodeTupleLifecycle, boolean isFiltering) {
        this.shouldExist = shouldExist;
        this.nextNodesTupleLifecycle = nextNodeTupleLifecycle;
        this.dirtyCounterQueue = new ArrayDeque<ExistsCounter<LeftTuple_>>(1000);
        this.isFiltering = isFiltering;
    }

    protected abstract boolean testFiltering(LeftTuple_ var1, UniTuple<Right_> var2);

    protected final void processInsert(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple, ExistsCounter<LeftTuple_> counter, Set<ExistsCounter<LeftTuple_>> counterSetRight) {
        if (!this.isFiltering || this.testFiltering(leftTuple, rightTuple)) {
            if (counter.countRight++ == 0) {
                if (this.shouldExist) {
                    this.insertCounter(counter);
                } else {
                    this.retractCounter(counter);
                }
            }
            counterSetRight.add(counter);
        }
    }

    protected final void processUpdate(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple, ExistsCounter<LeftTuple_> counter, Set<ExistsCounter<LeftTuple_>> counterSetRight) {
        if (this.testFiltering(leftTuple, rightTuple)) {
            if (counter.countRight++ == 0) {
                if (this.shouldExist) {
                    this.insertOrUpdateCounter(counter);
                } else {
                    this.retractOrRemainDeadCounter(counter);
                }
            }
            counterSetRight.add(counter);
        }
    }

    protected final void processAndClearCounters(Set<ExistsCounter<LeftTuple_>> counterSetRight) {
        this.processCounters(counterSetRight);
        counterSetRight.clear();
    }

    protected final void processCounters(Set<ExistsCounter<LeftTuple_>> counterSetRight) {
        for (ExistsCounter<LeftTuple_> counter : counterSetRight) {
            if (--counter.countRight != 0) continue;
            if (this.shouldExist) {
                this.retractCounter(counter);
                continue;
            }
            this.insertCounter(counter);
        }
    }

    protected final void processCounterUpdate(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: 
            case UPDATING: 
            case DYING: 
            case ABORTING: 
            case DEAD: {
                break;
            }
            case OK: {
                counter.state = BavetTupleState.UPDATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter.state + ") in node (" + this + ") is in an unexpected state (" + counter.state + ").");
            }
        }
    }

    private void insertCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case DYING: {
                counter.state = BavetTupleState.UPDATING;
                break;
            }
            case DEAD: {
                counter.state = BavetTupleState.CREATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            case ABORTING: {
                counter.state = BavetTupleState.CREATING;
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + counter.state + ").");
            }
        }
    }

    protected final void insertOrUpdateCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: {
                counter.state = BavetTupleState.UPDATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            case DYING: {
                counter.state = BavetTupleState.UPDATING;
                break;
            }
            case DEAD: {
                counter.state = BavetTupleState.CREATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            case ABORTING: {
                counter.state = BavetTupleState.CREATING;
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + counter.state + ").");
            }
        }
    }

    protected final void retractOrRemainDeadCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: {
                counter.state = BavetTupleState.ABORTING;
                break;
            }
            case UPDATING: {
                counter.state = BavetTupleState.DYING;
                break;
            }
            case OK: {
                counter.state = BavetTupleState.DYING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            case DYING: 
            case ABORTING: 
            case DEAD: {
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + counter.state + ").");
            }
        }
    }

    protected final void retractCounter(ExistsCounter<LeftTuple_> counter) {
        switch (counter.state) {
            case CREATING: {
                counter.state = BavetTupleState.ABORTING;
                break;
            }
            case UPDATING: {
                counter.state = BavetTupleState.DYING;
                break;
            }
            case OK: {
                counter.state = BavetTupleState.DYING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + counter.state + ").");
            }
        }
    }

    @Override
    public final void calculateScore() {
        block6: for (ExistsCounter existsCounter : this.dirtyCounterQueue) {
            switch (existsCounter.state) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(existsCounter.leftTuple);
                    existsCounter.state = BavetTupleState.OK;
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(existsCounter.leftTuple);
                    existsCounter.state = BavetTupleState.OK;
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(existsCounter.leftTuple);
                    existsCounter.state = BavetTupleState.DEAD;
                    continue block6;
                }
                case ABORTING: {
                    existsCounter.state = BavetTupleState.DEAD;
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The dirty counter (" + existsCounter + ") has an non-dirty state (" + existsCounter.state + ").");
        }
        this.dirtyCounterQueue.clear();
    }
}

