/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import java.util.Objects;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetJoinBridgeBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.AbstractJoinNode;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.tri.BavetAbstractTriConstraintStream;
import org.optaplanner.constraint.streams.bavet.tri.IndexedJoinTriNode;
import org.optaplanner.constraint.streams.bavet.tri.UnindexedJoinTriNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.constraint.streams.common.tri.DefaultTriJoiner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetJoinTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetJoinBridgeBiConstraintStream<Solution_, A, B> leftParent;
    private final BavetJoinBridgeUniConstraintStream<Solution_, C> rightParent;
    private final DefaultTriJoiner<A, B, C> joiner;

    public BavetJoinTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetJoinBridgeBiConstraintStream<Solution_, A, B> leftParent, BavetJoinBridgeUniConstraintStream<Solution_, C> rightParent, DefaultTriJoiner<A, B, C> joiner) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
    }

    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int outputStoreSize = buildHelper.extractTupleStoreSize((ConstraintStream)this);
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory((AbstractJoiner)this.joiner);
        AbstractJoinNode node = indexerFactory.hasJoiners() ? new IndexedJoinTriNode(JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, outputStoreSize, indexerFactory.buildIndexer(true), indexerFactory.buildIndexer(false)) : new UnindexedJoinTriNode(downstream, outputStoreSize);
        buildHelper.addNode(node, (ConstraintStream)this.leftParent, (ConstraintStream)this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetJoinTriConstraintStream other = (BavetJoinTriConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent()) && Objects.equals(this.joiner, other.joiner);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.leftParent.getParent(), this.rightParent.getParent(), this.joiner});
    }

    public String toString() {
        return "TriJoin() with " + this.childStreamList.size() + " children";
    }
}

