/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractIfExistsNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.ExistsCounter;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.core.impl.util.FieldBasedScalingSet;

public abstract class AbstractIndexedIfExistsNode<LeftTuple_ extends Tuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeft;
    private final int inputStoreIndexRight;
    private final Indexer<LeftTuple_, ExistsCounter<LeftTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>, Set<ExistsCounter<LeftTuple_>>> indexerRight;

    protected AbstractIndexedIfExistsNode(boolean shouldExist, Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeft, int inputStoreIndexRight, TupleLifecycle<LeftTuple_> nextNodeTupleLifecycle, Indexer<LeftTuple_, ExistsCounter<LeftTuple_>> indexerLeft, Indexer<UniTuple<Right_>, Set<ExistsCounter<LeftTuple_>>> indexerRight, boolean isFiltering) {
        super(shouldExist, nextNodeTupleLifecycle, isFiltering);
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeft = inputStoreIndexLeft;
        this.inputStoreIndexRight = inputStoreIndexRight;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        if (leftTuple.getStore(this.inputStoreIndexLeft) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexProperties(leftTuple);
        leftTuple.setStore(this.inputStoreIndexLeft, indexProperties);
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple, this.shouldExist);
        this.indexerLeft.put(indexProperties, leftTuple, counter);
        this.indexerRight.visit(indexProperties, (rightTuple, counterSetRight) -> {
            if (!this.isFiltering || this.testFiltering(leftTuple, rightTuple)) {
                ++counter.countRight;
                counterSetRight.add(counter);
            }
        });
        if (counter.isAlive()) {
            counter.state = BavetTupleState.CREATING;
            this.dirtyCounterQueue.add(counter);
        }
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)leftTuple.getStore(this.inputStoreIndexLeft);
        if (oldIndexProperties == null) {
            this.insertLeft(leftTuple);
            return;
        }
        IndexProperties newIndexProperties = this.createIndexProperties(leftTuple);
        if (oldIndexProperties.equals(newIndexProperties)) {
            ExistsCounter<LeftTuple_> counter = this.indexerLeft.get(oldIndexProperties, leftTuple);
            if (!this.isFiltering) {
                this.processCounterUpdate(counter);
            } else {
                counter.countRight = 0;
                this.indexerRight.visit(oldIndexProperties, (rightTuple, counterSetRight) -> {
                    if (this.testFiltering(leftTuple, rightTuple)) {
                        ++counter.countRight;
                    } else {
                        counterSetRight.remove(counter);
                    }
                });
                if (counter.isAlive()) {
                    this.insertOrUpdateCounter(counter);
                } else {
                    this.retractOrRemainDeadCounter(counter);
                }
            }
        } else {
            ExistsCounter<LeftTuple_> counter = this.deindexLeft(leftTuple, oldIndexProperties);
            counter.countRight = 0;
            leftTuple.setStore(this.inputStoreIndexLeft, newIndexProperties);
            this.indexerLeft.put(newIndexProperties, leftTuple, counter);
            this.indexerRight.visit(newIndexProperties, (rightTuple, counterSetRight) -> {
                if (!this.isFiltering || this.testFiltering(leftTuple, rightTuple)) {
                    ++counter.countRight;
                    counterSetRight.add(counter);
                }
            });
            if (counter.isAlive()) {
                this.insertOrUpdateCounter(counter);
            } else {
                this.retractOrRemainDeadCounter(counter);
            }
        }
    }

    private ExistsCounter<LeftTuple_> deindexLeft(LeftTuple_ leftTuple, IndexProperties oldIndexProperties) {
        ExistsCounter<LeftTuple_> counter = this.indexerLeft.remove(oldIndexProperties, leftTuple);
        this.indexerRight.visit(oldIndexProperties, (rightTuple, counterSetRight) -> {
            boolean changed = counterSetRight.remove(counter);
            if (!changed && !this.isFiltering) {
                throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + oldIndexProperties + ") has a counter on the left side that doesn't exist on the right side.");
            }
        });
        return counter;
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        IndexProperties indexProperties = (IndexProperties)leftTuple.getStore(this.inputStoreIndexLeft);
        if (indexProperties == null) {
            return;
        }
        leftTuple.setStore(this.inputStoreIndexLeft, null);
        ExistsCounter<LeftTuple_> counter = this.deindexLeft(leftTuple, indexProperties);
        if (counter.isAlive()) {
            this.retractCounter(counter);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.getStore(this.inputStoreIndexRight) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.getFactA());
        rightTuple.setStore(this.inputStoreIndexRight, indexProperties);
        FieldBasedScalingSet counterSetRight = new FieldBasedScalingSet(LinkedHashSet::new);
        this.indexRight(rightTuple, indexProperties, (Set<ExistsCounter<LeftTuple_>>)counterSetRight);
    }

    private void indexRight(UniTuple<Right_> rightTuple, IndexProperties indexProperties, Set<ExistsCounter<LeftTuple_>> counterSetRight) {
        this.indexerRight.put(indexProperties, rightTuple, counterSetRight);
        this.indexerLeft.visit(indexProperties, (leftTuple, counter) -> this.processInsert(leftTuple, rightTuple, counter, counterSetRight));
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        IndexProperties oldIndexProperties = (IndexProperties)rightTuple.getStore(this.inputStoreIndexRight);
        if (oldIndexProperties == null) {
            this.insertRight(rightTuple);
            return;
        }
        IndexProperties newIndexProperties = this.mappingRight.apply(rightTuple.getFactA());
        if (oldIndexProperties.equals(newIndexProperties)) {
            if (this.isFiltering) {
                Set<ExistsCounter<LeftTuple_>> counterSetRight = this.indexerRight.get(oldIndexProperties, rightTuple);
                this.processAndClearCounters(counterSetRight);
                this.indexerLeft.visit(newIndexProperties, (leftTuple, counter) -> this.processUpdate(leftTuple, rightTuple, counter, counterSetRight));
            }
        } else {
            Set<ExistsCounter<LeftTuple_>> counterSetRight = this.indexerRight.remove(oldIndexProperties, rightTuple);
            this.processAndClearCounters(counterSetRight);
            rightTuple.setStore(this.inputStoreIndexRight, newIndexProperties);
            this.indexRight(rightTuple, newIndexProperties, counterSetRight);
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.getStore(this.inputStoreIndexRight);
        if (indexProperties == null) {
            return;
        }
        rightTuple.setStore(this.inputStoreIndexRight, null);
        Set<ExistsCounter<LeftTuple_>> counterSetRight = this.indexerRight.remove(indexProperties, rightTuple);
        this.processCounters(counterSetRight);
    }

    protected abstract IndexProperties createIndexProperties(LeftTuple_ var1);
}

