/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final TupleLifecycle<OutTuple_> nextNodesTupleLifecycle;
    protected final Queue<OutTuple_> dirtyTupleQueue;

    protected AbstractJoinNode(TupleLifecycle<OutTuple_> nextNodesTupleLifecycle) {
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.dirtyTupleQueue = new ArrayDeque<OutTuple_>(1000);
    }

    protected abstract MutableOutTuple_ createOutTuple(LeftTuple_ var1, UniTuple<Right_> var2);

    protected abstract void updateOutTupleLeft(MutableOutTuple_ var1, LeftTuple_ var2);

    protected abstract void updateOutTupleRight(MutableOutTuple_ var1, UniTuple<Right_> var2);

    protected final void insertTuple(Map<UniTuple<Right_>, MutableOutTuple_> outTupleMapLeft, LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        MutableOutTuple_ outTuple = this.createOutTuple(leftTuple, rightTuple);
        outTupleMapLeft.put(rightTuple, outTuple);
        this.dirtyTupleQueue.add(outTuple);
    }

    protected final void updateTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.UPDATING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    protected final void retractTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: {
                outTuple.setState(BavetTupleState.ABORTING);
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.DYING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            case UPDATING: {
                outTuple.setState(BavetTupleState.DYING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    @Override
    public final void calculateScore() {
        block6: for (Tuple tuple : this.dirtyTupleQueue) {
            switch (tuple.getState()) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(tuple);
                    tuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
                case ABORTING: {
                    tuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + tuple.getState() + ").");
        }
        this.dirtyTupleQueue.clear();
    }
}

