/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.quad;

import java.util.Objects;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.AbstractJoinNode;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.quad.BavetAbstractQuadConstraintStream;
import org.optaplanner.constraint.streams.bavet.quad.IndexedJoinQuadNode;
import org.optaplanner.constraint.streams.bavet.quad.UnindexedJoinQuadNode;
import org.optaplanner.constraint.streams.bavet.tri.BavetJoinBridgeTriConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.constraint.streams.common.quad.DefaultQuadJoiner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetJoinQuadConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetJoinBridgeTriConstraintStream<Solution_, A, B, C> leftParent;
    private final BavetJoinBridgeUniConstraintStream<Solution_, D> rightParent;
    private final DefaultQuadJoiner<A, B, C, D> joiner;

    public BavetJoinQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetJoinBridgeTriConstraintStream<Solution_, A, B, C> leftParent, BavetJoinBridgeUniConstraintStream<Solution_, D> rightParent, DefaultQuadJoiner<A, B, C, D> joiner) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.joiner = joiner;
    }

    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int outputStoreSize = buildHelper.extractTupleStoreSize((ConstraintStream)this);
        TupleLifecycle downstream = buildHelper.getAggregatedTupleLifecycle(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory((AbstractJoiner)this.joiner);
        AbstractJoinNode node = indexerFactory.hasJoiners() ? new IndexedJoinQuadNode(JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource()), buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource()), downstream, outputStoreSize, indexerFactory.buildIndexer(true), indexerFactory.buildIndexer(false)) : new UnindexedJoinQuadNode(downstream, outputStoreSize);
        buildHelper.addNode(node, (ConstraintStream)this.leftParent, (ConstraintStream)this.rightParent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BavetJoinQuadConstraintStream other = (BavetJoinQuadConstraintStream)o;
        return Objects.equals(this.leftParent.getParent(), other.leftParent.getParent()) && Objects.equals(this.rightParent.getParent(), other.rightParent.getParent()) && Objects.equals(this.joiner, other.joiner);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.leftParent.getParent(), this.rightParent.getParent(), this.joiner});
    }

    public String toString() {
        return "QuadJoin() with " + this.childStreamList.size() + " children";
    }
}

