/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.AbstractIndexerTest;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.constraint.streams.bavet.uni.UniTupleImpl;

class NoneIndexerTest
extends AbstractIndexerTest {
    NoneIndexerTest() {
    }

    @Test
    void getEmpty() {
        NoneIndexer indexer = new NoneIndexer();
        SoftAssertions.assertSoftly(arg_0 -> this.lambda$getEmpty$0((Indexer)indexer, arg_0));
    }

    @Test
    void putTwice() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple, (Object)"Ann value");
        SoftAssertions.assertSoftly(arg_0 -> this.lambda$putTwice$1((Indexer)indexer, annTuple, arg_0));
        Assertions.assertThatThrownBy(() -> NoneIndexerTest.lambda$putTwice$2((Indexer)indexer, annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void removeTwice() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple, (Object)"Ann value");
        SoftAssertions.assertSoftly(arg_0 -> this.lambda$removeTwice$3((Indexer)indexer, annTuple, arg_0));
        UniTuple<String> ednaTuple = NoneIndexerTest.newTuple("Edna-F-40");
        Assertions.assertThatThrownBy(() -> NoneIndexerTest.lambda$removeTwice$4((Indexer)indexer, ednaTuple)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThat((String)((String)indexer.remove((IndexProperties)NoneIndexProperties.INSTANCE, annTuple))).isEqualTo("Ann value");
        SoftAssertions.assertSoftly(arg_0 -> this.lambda$removeTwice$5((Indexer)indexer, arg_0));
        Assertions.assertThatThrownBy(() -> NoneIndexerTest.lambda$removeTwice$6((Indexer)indexer, annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void visit() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple, (Object)"Ann value");
        UniTuple<String> bethTuple = NoneIndexerTest.newTuple("Beth-F-30");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, bethTuple, (Object)"Beth value");
        Assertions.assertThat(this.getTupleMap(indexer, new Object[0])).containsOnlyKeys((Object[])new UniTuple[]{annTuple, bethTuple});
    }

    private static UniTuple<String> newTuple(String factA) {
        return new UniTupleImpl((Object)factA, 0);
    }

    private static /* synthetic */ void lambda$removeTwice$6(Indexer indexer, UniTuple annTuple) throws Throwable {
        indexer.remove((IndexProperties)NoneIndexProperties.INSTANCE, (Tuple)annTuple);
    }

    private /* synthetic */ void lambda$removeTwice$5(Indexer indexer, SoftAssertions softly) {
        softly.assertThat(indexer.isEmpty()).isTrue();
        softly.assertThat(this.getTupleMap(indexer, new Object[0])).isEmpty();
    }

    private static /* synthetic */ void lambda$removeTwice$4(Indexer indexer, UniTuple ednaTuple) throws Throwable {
        indexer.remove((IndexProperties)NoneIndexProperties.INSTANCE, (Tuple)ednaTuple);
    }

    private /* synthetic */ void lambda$removeTwice$3(Indexer indexer, UniTuple annTuple, SoftAssertions softly) {
        softly.assertThat(indexer.isEmpty()).isFalse();
        softly.assertThat(this.getTupleMap(indexer, new Object[0])).containsExactly(new Map.Entry[]{Map.entry(annTuple, "Ann value")});
    }

    private static /* synthetic */ void lambda$putTwice$2(Indexer indexer, UniTuple annTuple) throws Throwable {
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, (Tuple)annTuple, (Object)"Ann value");
    }

    private /* synthetic */ void lambda$putTwice$1(Indexer indexer, UniTuple annTuple, SoftAssertions softly) {
        softly.assertThat(indexer.isEmpty()).isFalse();
        softly.assertThat(this.getTupleMap(indexer, new Object[0])).containsExactly(new Map.Entry[]{Map.entry(annTuple, "Ann value")});
    }

    private /* synthetic */ void lambda$getEmpty$0(Indexer indexer, SoftAssertions softly) {
        softly.assertThat(this.getTupleMap(indexer, new Object[0])).isEmpty();
        softly.assertThat(indexer.isEmpty()).isTrue();
    }
}

