/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.common.AbstractIfExistsNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.ExistsCounter;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.core.impl.util.FieldBasedScalingSet;

public abstract class AbstractUnindexedIfExistsNode<LeftTuple_ extends Tuple, Right_>
extends AbstractIfExistsNode<LeftTuple_, Right_>
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    private final Map<LeftTuple_, ExistsCounter<LeftTuple_>> leftMap = new LinkedHashMap<LeftTuple_, ExistsCounter<LeftTuple_>>();
    private final Map<UniTuple<Right_>, Set<ExistsCounter<LeftTuple_>>> rightMap = new LinkedHashMap<UniTuple<Right_>, Set<ExistsCounter<LeftTuple_>>>();

    protected AbstractUnindexedIfExistsNode(boolean shouldExist, TupleLifecycle<LeftTuple_> nextNodeTupleLifecycle, boolean isFiltering) {
        super(shouldExist, nextNodeTupleLifecycle, isFiltering);
    }

    @Override
    public final void insertLeft(LeftTuple_ leftTuple) {
        ExistsCounter<LeftTuple_> counter = new ExistsCounter<LeftTuple_>(leftTuple, this.shouldExist);
        this.leftMap.put(leftTuple, counter);
        for (Map.Entry<UniTuple<Right_>, Set<ExistsCounter<LeftTuple_>>> entry : this.rightMap.entrySet()) {
            UniTuple<Right_> rightTuple = entry.getKey();
            if (this.isFiltering && !this.testFiltering(leftTuple, rightTuple)) continue;
            ++counter.countRight;
            Set<ExistsCounter<LeftTuple_>> counterSetRight = entry.getValue();
            counterSetRight.add(counter);
        }
        if (counter.isAlive()) {
            counter.state = BavetTupleState.CREATING;
            this.dirtyCounterQueue.add(counter);
        }
    }

    @Override
    public final void updateLeft(LeftTuple_ leftTuple) {
        ExistsCounter<LeftTuple_> counter = this.leftMap.get(leftTuple);
        if (counter == null) {
            this.insertLeft(leftTuple);
            return;
        }
        if (!this.isFiltering) {
            this.processCounterUpdate(counter);
        } else {
            counter.countRight = 0;
            for (Map.Entry<UniTuple<Right_>, Set<ExistsCounter<LeftTuple_>>> entry : this.rightMap.entrySet()) {
                UniTuple<Right_> rightTuple = entry.getKey();
                if (this.testFiltering(leftTuple, rightTuple)) {
                    ++counter.countRight;
                    continue;
                }
                Set<ExistsCounter<LeftTuple_>> counterSetRight = entry.getValue();
                counterSetRight.remove(counter);
            }
            if (counter.isAlive()) {
                this.insertOrUpdateCounter(counter);
            } else {
                this.retractOrRemainDeadCounter(counter);
            }
        }
    }

    @Override
    public final void retractLeft(LeftTuple_ leftTuple) {
        ExistsCounter<LeftTuple_> counter = this.leftMap.remove(leftTuple);
        if (counter == null) {
            return;
        }
        for (Set<ExistsCounter<LeftTuple_>> counterSetRight : this.rightMap.values()) {
            boolean changed = counterSetRight.remove(counter);
            if (changed || this.isFiltering) continue;
            throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") has a counter on the left side that doesn't exist on the right side.");
        }
        if (counter.isAlive()) {
            this.retractCounter(counter);
        }
    }

    @Override
    public final void insertRight(UniTuple<Right_> rightTuple) {
        FieldBasedScalingSet counterSetRight = new FieldBasedScalingSet(LinkedHashSet::new);
        this.rightMap.put(rightTuple, (Set<ExistsCounter<LeftTuple_>>)counterSetRight);
        for (Map.Entry<LeftTuple_, ExistsCounter<LeftTuple_>> entry : this.leftMap.entrySet()) {
            Tuple leftTuple = (Tuple)entry.getKey();
            ExistsCounter<LeftTuple_> counter = entry.getValue();
            this.processInsert(leftTuple, rightTuple, counter, counterSetRight);
        }
    }

    @Override
    public final void updateRight(UniTuple<Right_> rightTuple) {
        Set<ExistsCounter<LeftTuple_>> counterSetRight = this.rightMap.get(rightTuple);
        if (counterSetRight == null) {
            this.insertRight(rightTuple);
        } else if (this.isFiltering) {
            this.processAndClearCounters(counterSetRight);
            for (Map.Entry<LeftTuple_, ExistsCounter<LeftTuple_>> entry : this.leftMap.entrySet()) {
                Tuple leftTuple = (Tuple)entry.getKey();
                ExistsCounter<LeftTuple_> counter = entry.getValue();
                this.processUpdate(leftTuple, rightTuple, counter, counterSetRight);
            }
        }
    }

    @Override
    public final void retractRight(UniTuple<Right_> rightTuple) {
        Set<ExistsCounter<LeftTuple_>> counterSetRight = this.rightMap.remove(rightTuple);
        if (counterSetRight == null) {
            return;
        }
        this.processCounters(counterSetRight);
    }
}

