/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.common.index.AbstractIndexerTest;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.ManyIndexProperties;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.constraint.streams.bavet.uni.UniTupleImpl;
import org.optaplanner.constraint.streams.common.bi.DefaultBiJoiner;
import org.optaplanner.core.api.score.stream.Joiners;

class EqualsAndComparisonIndexerTest
extends AbstractIndexerTest {
    private final DefaultBiJoiner<AbstractIndexerTest.Person, AbstractIndexerTest.Person> joiner = (DefaultBiJoiner)Joiners.equal(p -> p.gender).and(Joiners.lessThanOrEqual(a -> a.age));

    EqualsAndComparisonIndexerTest() {
    }

    @Test
    void iEmpty() {
        Indexer indexer = new IndexerFactory(this.joiner).buildIndexer(true);
        Assertions.assertThat(this.getTuples(indexer, "F", 40)).isEmpty();
    }

    @Test
    void put() {
        Indexer indexer = new IndexerFactory(this.joiner).buildIndexer(true);
        UniTuple<String> annTuple = EqualsAndComparisonIndexerTest.newTuple("Ann-F-40");
        Assertions.assertThat((int)indexer.size((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}))).isEqualTo(0);
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annTuple);
        Assertions.assertThat((int)indexer.size((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}))).isEqualTo(1);
    }

    @Test
    void removeTwice() {
        Indexer indexer = new IndexerFactory(this.joiner).buildIndexer(true);
        UniTuple<String> annTuple = EqualsAndComparisonIndexerTest.newTuple("Ann-F-40");
        TupleListEntry annEntry = indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annTuple);
        indexer.remove((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annEntry);
        Assertions.assertThatThrownBy(() -> indexer.remove((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annEntry)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void visit() {
        Indexer indexer = new IndexerFactory(this.joiner).buildIndexer(true);
        UniTuple<String> annTuple = EqualsAndComparisonIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annTuple);
        UniTuple<String> bethTuple = EqualsAndComparisonIndexerTest.newTuple("Beth-F-30");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 30}), bethTuple);
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"M", 40}), EqualsAndComparisonIndexerTest.newTuple("Carl-M-40"));
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"M", 30}), EqualsAndComparisonIndexerTest.newTuple("Dan-M-30"));
        UniTuple<String> ednaTuple = EqualsAndComparisonIndexerTest.newTuple("Edna-F-40");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), ednaTuple);
        Assertions.assertThat(this.getTuples(indexer, "F", 40)).containsOnly((Object[])new UniTuple[]{annTuple, bethTuple, ednaTuple});
        Assertions.assertThat(this.getTuples(indexer, "F", 35)).containsOnly((Object[])new UniTuple[]{bethTuple});
        Assertions.assertThat(this.getTuples(indexer, "F", 30)).containsOnly((Object[])new UniTuple[]{bethTuple});
        Assertions.assertThat(this.getTuples(indexer, "F", 20)).isEmpty();
    }

    private static UniTuple<String> newTuple(String factA) {
        return new UniTupleImpl((Object)factA, 0);
    }
}

