/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;

public abstract class AbstractScorer<Tuple_ extends Tuple>
implements TupleLifecycle<Tuple_> {
    private final String constraintId;
    private final Score<?> constraintWeight;
    private final int inputStoreIndex;

    protected AbstractScorer(String constraintPackage, String constraintName, Score<?> constraintWeight, int inputStoreIndex) {
        this.constraintId = ConstraintMatchTotal.composeConstraintId((String)constraintPackage, (String)constraintName);
        this.constraintWeight = constraintWeight;
        this.inputStoreIndex = inputStoreIndex;
    }

    @Override
    public final void insert(Tuple_ tuple) {
        if (tuple.getStore(this.inputStoreIndex) != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        tuple.setStore(this.inputStoreIndex, this.impact(tuple));
    }

    @Override
    public final void update(Tuple_ tuple) {
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)tuple.getStore(this.inputStoreIndex);
        if (undoScoreImpacter != null) {
            undoScoreImpacter.run();
        }
        tuple.setStore(this.inputStoreIndex, this.impact(tuple));
    }

    protected abstract UndoScoreImpacter impact(Tuple_ var1);

    @Override
    public final void retract(Tuple_ tuple) {
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)tuple.getStore(this.inputStoreIndex);
        if (undoScoreImpacter != null) {
            undoScoreImpacter.run();
            tuple.setStore(this.inputStoreIndex, null);
        }
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.constraintId + ") with constraintWeight (" + this.constraintWeight + ")";
    }
}

