/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.uni.FlattenLastUniNode;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.constraint.streams.bavet.uni.UniTupleImpl;

@ExtendWith(value={MockitoExtension.class})
class FlattenLastUniNodeTest {
    @Mock
    private TupleLifecycle<UniTuple<String>> downstream;

    FlattenLastUniNodeTest() {
    }

    private static String merge(String ... facts) {
        return Arrays.stream(facts).map(String::intern).collect(Collectors.joining(","));
    }

    private static List<String> split(String factString) {
        return Arrays.stream(factString.split(",")).map(String::intern).collect(Collectors.toList());
    }

    private static UniTuple<String> createTuple(String ... facts) {
        return new UniTupleImpl((Object)FlattenLastUniNodeTest.merge(facts), 1);
    }

    private static UniTuple<String> modifyTuple(UniTuple<String> tuple, String ... facts) {
        ((UniTupleImpl)tuple).factA = FlattenLastUniNodeTest.merge(facts);
        return tuple;
    }

    @Test
    void insertAndRetract() {
        FlattenLastUniNode node = new FlattenLastUniNode(0, FlattenLastUniNodeTest::split, this.downstream, 1);
        UniTuple<String> firstTuple = FlattenLastUniNodeTest.createTuple("A", "B");
        node.insert(firstTuple);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.downstream});
        node.calculateScore();
        ((TupleLifecycle)Mockito.verify(this.downstream)).insert((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "A"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).insert((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "B"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.downstream});
        Mockito.reset((Object[])new TupleLifecycle[]{this.downstream});
        UniTuple<String> secondTuple = FlattenLastUniNodeTest.createTuple("B", "C");
        node.insert(secondTuple);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.downstream});
        node.calculateScore();
        ((TupleLifecycle)Mockito.verify(this.downstream)).insert((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "B"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).insert((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "C"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.downstream});
        Mockito.reset((Object[])new TupleLifecycle[]{this.downstream});
        node.retract(firstTuple);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.downstream});
        node.calculateScore();
        ((TupleLifecycle)Mockito.verify(this.downstream)).retract((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "A"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).retract((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "B"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.downstream});
        Mockito.reset((Object[])new TupleLifecycle[]{this.downstream});
        node.retract(secondTuple);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.downstream});
        node.calculateScore();
        ((TupleLifecycle)Mockito.verify(this.downstream)).retract((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "B"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).retract((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "C"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.downstream});
        Mockito.reset((Object[])new TupleLifecycle[]{this.downstream});
        node.calculateScore();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.downstream});
    }

    @Test
    void modify() {
        FlattenLastUniNode node = new FlattenLastUniNode(0, FlattenLastUniNodeTest::split, this.downstream, 1);
        UniTuple<String> firstTuple = FlattenLastUniNodeTest.createTuple("A", "B");
        node.insert(firstTuple);
        UniTuple<String> secondTuple = FlattenLastUniNodeTest.createTuple("B", "C");
        node.insert(secondTuple);
        node.calculateScore();
        Mockito.reset((Object[])new TupleLifecycle[]{this.downstream});
        firstTuple = FlattenLastUniNodeTest.modifyTuple(firstTuple, "B", "X", "B");
        node.update(firstTuple);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.downstream});
        node.calculateScore();
        ((TupleLifecycle)Mockito.verify(this.downstream)).retract((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "A"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).update((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "B"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).insert((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "X"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).insert((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "B"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.downstream});
        Mockito.reset((Object[])new TupleLifecycle[]{this.downstream});
        secondTuple = FlattenLastUniNodeTest.modifyTuple(secondTuple, "X", "C");
        node.update(secondTuple);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.downstream});
        node.calculateScore();
        ((TupleLifecycle)Mockito.verify(this.downstream)).retract((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "B"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).update((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "C"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).insert((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "X"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.downstream});
        Mockito.reset((Object[])new TupleLifecycle[]{this.downstream});
        firstTuple = FlattenLastUniNodeTest.modifyTuple(firstTuple, "X");
        node.update(firstTuple);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.downstream});
        node.calculateScore();
        ((TupleLifecycle)Mockito.verify(this.downstream, (VerificationMode)Mockito.times((int)2))).retract((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "B"))));
        ((TupleLifecycle)Mockito.verify(this.downstream)).update((Tuple)((UniTuple)Mockito.argThat(t -> Objects.equals(t.getFactA(), "X"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.downstream});
    }
}

