/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleList;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple, MutableOutTuple_ extends OutTuple_>
extends AbstractNode
implements LeftTupleLifecycle<LeftTuple_>,
RightTupleLifecycle<UniTuple<Right_>> {
    protected final int inputStoreIndexLeftOutTupleList;
    protected final int inputStoreIndexRightOutTupleList;
    private final TupleLifecycle<OutTuple_> nextNodesTupleLifecycle;
    private final boolean isFiltering;
    private final int outputStoreIndexLeftOutEntry;
    private final int outputStoreIndexRightOutEntry;
    protected final Queue<OutTuple_> dirtyTupleQueue;

    protected AbstractJoinNode(int inputStoreIndexLeftOutTupleList, int inputStoreIndexRightOutTupleList, TupleLifecycle<OutTuple_> nextNodesTupleLifecycle, boolean isFiltering, int outputStoreIndexLeftOutEntry, int outputStoreIndexRightOutEntry) {
        this.inputStoreIndexLeftOutTupleList = inputStoreIndexLeftOutTupleList;
        this.inputStoreIndexRightOutTupleList = inputStoreIndexRightOutTupleList;
        this.nextNodesTupleLifecycle = nextNodesTupleLifecycle;
        this.isFiltering = isFiltering;
        this.outputStoreIndexLeftOutEntry = outputStoreIndexLeftOutEntry;
        this.outputStoreIndexRightOutEntry = outputStoreIndexRightOutEntry;
        this.dirtyTupleQueue = new ArrayDeque<OutTuple_>(1000);
    }

    protected abstract MutableOutTuple_ createOutTuple(LeftTuple_ var1, UniTuple<Right_> var2);

    protected abstract void setOutTupleLeftFacts(MutableOutTuple_ var1, LeftTuple_ var2);

    protected abstract void setOutTupleRightFact(MutableOutTuple_ var1, UniTuple<Right_> var2);

    protected abstract boolean testFiltering(LeftTuple_ var1, UniTuple<Right_> var2);

    protected final void insertOutTuple(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        MutableOutTuple_ outTuple = this.createOutTuple(leftTuple, rightTuple);
        TupleList outTupleListLeft = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftOutTupleList);
        TupleListEntry<MutableOutTuple_> outEntryLeft = outTupleListLeft.add(outTuple);
        outTuple.setStore(this.outputStoreIndexLeftOutEntry, outEntryLeft);
        TupleList outTupleListRight = (TupleList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
        TupleListEntry<MutableOutTuple_> outEntryRight = outTupleListRight.add(outTuple);
        outTuple.setStore(this.outputStoreIndexRightOutEntry, outEntryRight);
        this.dirtyTupleQueue.add(outTuple);
    }

    protected final void insertOutTupleFiltered(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple) {
        if (!this.isFiltering || this.testFiltering(leftTuple, rightTuple)) {
            this.insertOutTuple(leftTuple, rightTuple);
        }
    }

    protected final void innerUpdateLeft(LeftTuple_ leftTuple, Consumer<Consumer<UniTuple<Right_>>> rightTupleConsumer) {
        TupleList outTupleListLeft = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftOutTupleList);
        if (!this.isFiltering) {
            outTupleListLeft.forEach(outTuple -> this.updateOutTupleLeft(outTuple, leftTuple));
        } else {
            IdentityHashMap rightToOutMap = new IdentityHashMap(outTupleListLeft.size());
            outTupleListLeft.forEach(outTuple -> {
                TupleListEntry rightOutEntry = (TupleListEntry)outTuple.getStore(this.outputStoreIndexRightOutEntry);
                rightToOutMap.put(rightOutEntry.getList(), outTuple);
            });
            rightTupleConsumer.accept(rightTuple -> {
                TupleList rightOutList = (TupleList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
                this.processOutTupleUpdate(leftTuple, (UniTuple<Right_>)rightTuple, rightToOutMap, rightOutList);
            });
        }
    }

    private void updateOutTupleLeft(MutableOutTuple_ outTuple, LeftTuple_ leftTuple) {
        this.setOutTupleLeftFacts(outTuple, leftTuple);
        this.doUpdateOutTuple(outTuple);
    }

    private void doUpdateOutTuple(OutTuple_ outTuple) {
        switch (outTuple.getState()) {
            case CREATING: 
            case UPDATING: {
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.UPDATING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    protected final void innerUpdateRight(UniTuple<Right_> rightTuple, Consumer<Consumer<LeftTuple_>> leftTupleConsumer) {
        TupleList outTupleListRight = (TupleList)rightTuple.getStore(this.inputStoreIndexRightOutTupleList);
        if (!this.isFiltering) {
            outTupleListRight.forEach(outTuple -> {
                this.setOutTupleRightFact(outTuple, rightTuple);
                this.doUpdateOutTuple(outTuple);
            });
        } else {
            IdentityHashMap leftToOutMap = new IdentityHashMap(outTupleListRight.size());
            outTupleListRight.forEach(outTuple -> {
                TupleListEntry leftOutEntry = (TupleListEntry)outTuple.getStore(this.outputStoreIndexLeftOutEntry);
                leftToOutMap.put(leftOutEntry.getList(), outTuple);
            });
            leftTupleConsumer.accept(leftTuple -> {
                TupleList leftOutList = (TupleList)leftTuple.getStore(this.inputStoreIndexLeftOutTupleList);
                this.processOutTupleUpdate(leftTuple, rightTuple, leftToOutMap, leftOutList);
            });
        }
    }

    private void processOutTupleUpdate(LeftTuple_ leftTuple, UniTuple<Right_> rightTuple, Map<TupleList<MutableOutTuple_>, MutableOutTuple_> outMap, TupleList<MutableOutTuple_> outList) {
        Tuple outTuple = (Tuple)outMap.get(outList);
        if (this.testFiltering(leftTuple, rightTuple)) {
            if (outTuple == null) {
                this.insertOutTuple(leftTuple, rightTuple);
            } else {
                this.updateOutTupleLeft(outTuple, leftTuple);
            }
        } else if (outTuple != null) {
            this.retractOutTuple(outTuple);
        }
    }

    protected final void retractOutTuple(MutableOutTuple_ outTuple) {
        TupleListEntry outEntryLeft = (TupleListEntry)outTuple.removeStore(this.outputStoreIndexLeftOutEntry);
        outEntryLeft.remove();
        TupleListEntry outEntryRight = (TupleListEntry)outTuple.removeStore(this.outputStoreIndexRightOutEntry);
        outEntryRight.remove();
        switch (outTuple.getState()) {
            case CREATING: {
                outTuple.setState(BavetTupleState.ABORTING);
                break;
            }
            case OK: {
                outTuple.setState(BavetTupleState.DYING);
                this.dirtyTupleQueue.add(outTuple);
                break;
            }
            case UPDATING: {
                outTuple.setState(BavetTupleState.DYING);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The tuple (" + outTuple.getState() + ") in node (" + this + ") is in an unexpected state (" + outTuple.getState() + ").");
            }
        }
    }

    @Override
    public final void calculateScore() {
        block6: for (Tuple tuple : this.dirtyTupleQueue) {
            switch (tuple.getState()) {
                case CREATING: {
                    this.nextNodesTupleLifecycle.insert(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case UPDATING: {
                    this.nextNodesTupleLifecycle.update(tuple);
                    tuple.setState(BavetTupleState.OK);
                    continue block6;
                }
                case DYING: {
                    this.nextNodesTupleLifecycle.retract(tuple);
                    tuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
                case ABORTING: {
                    tuple.setState(BavetTupleState.DEAD);
                    continue block6;
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + tuple.getState() + ").");
        }
        this.dirtyTupleQueue.clear();
    }
}

