/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

class NodeSharingTest {
    NodeSharingTest() {
    }

    @Test
    void nodeSharingForEach() {
        BavetConstraintFactory constraintFactory = new BavetConstraintFactory(TestdataSolution.buildSolutionDescriptor(), EnvironmentMode.REPRODUCIBLE);
        UniConstraintStream stream1 = constraintFactory.forEach(TestdataEntity.class);
        UniConstraintStream stream2 = constraintFactory.forEach(TestdataEntity.class);
        Assertions.assertThat((Object)stream1).isSameAs((Object)stream2);
        Predicate<TestdataEntity> predicate = entity -> true;
        UniConstraintStream filteredStream1 = stream1.filter(predicate);
        UniConstraintStream filteredStream2 = stream2.filter(predicate);
        Assertions.assertThat((Object)filteredStream1).isSameAs((Object)filteredStream2);
    }

    @Test
    void nodeSharingForEachUniquePair() {
        BavetConstraintFactory constraintFactory = new BavetConstraintFactory(TestdataSolution.buildSolutionDescriptor(), EnvironmentMode.REPRODUCIBLE);
        BiConstraintStream stream1 = constraintFactory.forEachUniquePair(TestdataEntity.class);
        BiConstraintStream stream2 = constraintFactory.forEachUniquePair(TestdataEntity.class);
        Assertions.assertThat((Object)stream1).isSameAs((Object)stream2);
        BiPredicate<TestdataEntity, TestdataEntity> predicate = (a, b) -> true;
        BiConstraintStream filteredStream1 = stream1.filter(predicate);
        BiConstraintStream filteredStream2 = stream2.filter(predicate);
        Assertions.assertThat((Object)filteredStream1).isSameAs((Object)filteredStream2);
    }

    @Test
    void nodeSharingForEachUniquePairAndOneMore() {
        BavetConstraintFactory constraintFactory = new BavetConstraintFactory(TestdataSolution.buildSolutionDescriptor(), EnvironmentMode.REPRODUCIBLE);
        TriConstraintStream stream1 = constraintFactory.forEachUniquePair(TestdataEntity.class).join(TestdataEntity.class);
        TriConstraintStream stream2 = constraintFactory.forEachUniquePair(TestdataEntity.class).join(TestdataEntity.class);
        Assertions.assertThat((Object)stream1).isSameAs((Object)stream2);
        TriPredicate predicate = (a, b, c) -> true;
        TriConstraintStream filteredStream1 = stream1.filter(predicate);
        TriConstraintStream filteredStream2 = stream2.filter(predicate);
        Assertions.assertThat((Object)filteredStream1).isSameAs((Object)filteredStream2);
    }
}

