/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.optaplanner.constraint.streams.common.ConstraintStreamImplSupport;
import org.optaplanner.constraint.streams.common.ConstraintStreamTestExtension;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishSolution;

@ExtendWith(value={ConstraintStreamTestExtension.class})
public abstract class AbstractConstraintStreamTest {
    protected static final String TEST_CONSTRAINT_NAME = "testConstraintName";
    private final ConstraintStreamImplSupport implSupport;

    protected final void assumeBavet() {
        this.implSupport.assumeBavet();
    }

    protected void assumeDrools() {
        this.implSupport.assumeDrools();
    }

    protected AbstractConstraintStreamTest(ConstraintStreamImplSupport implSupport) {
        this.implSupport = Objects.requireNonNull(implSupport);
    }

    protected InnerScoreDirector<TestdataLavishSolution, SimpleScore> buildScoreDirector(Function<ConstraintFactory, Constraint> function) {
        return this.buildScoreDirector(TestdataLavishSolution.buildSolutionDescriptor(), factory -> new Constraint[]{(Constraint)function.apply(factory)});
    }

    protected <Score_ extends Score<Score_>, Solution_> InnerScoreDirector<Solution_, Score_> buildScoreDirector(SolutionDescriptor<Solution_> solutionDescriptorSupplier, ConstraintProvider constraintProvider) {
        return this.implSupport.buildScoreDirector(solutionDescriptorSupplier, constraintProvider);
    }

    protected <Solution_> void assertScore(InnerScoreDirector<Solution_, SimpleScore> scoreDirector, AssertableMatch ... assertableMatches) {
        scoreDirector.triggerVariableListeners();
        SimpleScore score = (SimpleScore)scoreDirector.calculateScore();
        int scoreTotal = Arrays.stream(assertableMatches).mapToInt(assertableMatch -> assertableMatch.score).sum();
        if (this.implSupport.isConstreamMatchEnabled()) {
            String constraintPackage = scoreDirector.getSolutionDescriptor().getSolutionClass().getPackage().getName();
            for (AssertableMatch assertableMatch2 : assertableMatches) {
                String constraintId;
                Map constraintMatchTotals = scoreDirector.getConstraintMatchTotalMap();
                ConstraintMatchTotal constraintMatchTotal = (ConstraintMatchTotal)constraintMatchTotals.get(constraintId = ConstraintMatchTotal.composeConstraintId((String)constraintPackage, (String)assertableMatch2.constraintName));
                if (constraintMatchTotal == null) {
                    throw new IllegalStateException("Requested constraint matches for unknown constraint (" + constraintId + ").");
                }
                if (!constraintMatchTotal.getConstraintMatchSet().stream().noneMatch(assertableMatch2::isEqualTo)) continue;
                Assertions.fail((String)("The assertableMatch (" + assertableMatch2 + ") is lacking, it's not in the constraintMatchSet (" + constraintMatchTotal.getConstraintMatchSet() + ")."));
            }
            Map constraintMatchTotalMap = scoreDirector.getConstraintMatchTotalMap();
            for (ConstraintMatchTotal constraintMatchTotal : constraintMatchTotalMap.values()) {
                for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                    if (!Arrays.stream(assertableMatches).filter(assertableMatch -> assertableMatch.constraintName.equals(constraintMatch.getConstraintName())).noneMatch(assertableMatch -> assertableMatch.isEqualTo(constraintMatch))) continue;
                    Assertions.fail((String)("The constraintMatch (" + constraintMatch + ") is in excess, it's not in the assertableMatches (" + Arrays.toString(assertableMatches) + ")."));
                }
            }
        }
        Assertions.assertThat((int)score.getScore()).isEqualTo(scoreTotal);
    }

    protected static AssertableMatch assertMatch(Object ... justifications) {
        return AbstractConstraintStreamTest.assertMatchWithScore(-1, justifications);
    }

    protected static AssertableMatch assertMatch(String constraintName, Object ... justifications) {
        return AbstractConstraintStreamTest.assertMatchWithScore(-1, constraintName, justifications);
    }

    protected static AssertableMatch assertMatchWithScore(int score, Object ... justifications) {
        return AbstractConstraintStreamTest.assertMatchWithScore(score, TEST_CONSTRAINT_NAME, justifications);
    }

    protected static AssertableMatch assertMatchWithScore(int score, String constraintName, Object ... justifications) {
        return new AssertableMatch(score, constraintName, justifications);
    }

    protected static Set<Object> asSet(Object ... facts) {
        return Arrays.stream(facts).collect(Collectors.toSet());
    }

    protected static class AssertableMatch {
        private final int score;
        private final String constraintName;
        private final List<Object> justificationList;

        public AssertableMatch(int score, String constraintName, Object ... justifications) {
            this.justificationList = Arrays.asList(justifications);
            this.constraintName = constraintName;
            this.score = score;
        }

        public boolean isEqualTo(ConstraintMatch constraintMatch) {
            if (this.score != ((SimpleScore)constraintMatch.getScore()).getScore()) {
                return false;
            }
            if (!this.constraintName.equals(constraintMatch.getConstraintName())) {
                return false;
            }
            List actualJustificationList = constraintMatch.getJustificationList();
            if (actualJustificationList.size() != this.justificationList.size()) {
                return false;
            }
            return this.justificationList.containsAll(actualJustificationList);
        }

        public String toString() {
            return this.constraintName + " " + this.justificationList + "=" + this.score;
        }
    }
}

