/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.quad;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamTest;
import org.optaplanner.constraint.streams.common.ConstraintStreamFunctionalTest;
import org.optaplanner.constraint.streams.common.ConstraintStreamImplSupport;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.score.TestdataSimpleBigDecimalScoreSolution;
import org.optaplanner.core.impl.testdata.domain.score.TestdataSimpleLongScoreSolution;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntity;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntityGroup;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishExtra;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishSolution;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValue;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValueGroup;

public abstract class AbstractQuadConstraintStreamTest
extends AbstractConstraintStreamTest
implements ConstraintStreamFunctionalTest {
    protected AbstractQuadConstraintStreamTest(ConstraintStreamImplSupport implSupport) {
        super(implSupport);
    }

    @Override
    @TestTemplate
    public void filter_entity() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity3);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        solution.getExtraList().add(extra2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.equal((e1, e2) -> e1.getValue(), Function.identity())).join(TestdataLavishExtra.class).filter((e1, e2, value, extra) -> value.getCode().equals("MyValue 1") && extra.getCode().equals("MyExtra 1")).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, value1, extra1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, value1, extra1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity3);
        entity3.setValue(value2);
        scoreDirector.afterProblemPropertyChanged((Object)entity3);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, value1, extra1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, value1, extra1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setValue(value1);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, value1, extra1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, value1, extra1), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, value1, extra1));
    }

    @Override
    @TestTemplate
    public void filter_consecutive() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)5, (int)5);
        TestdataLavishEntity entity1 = (TestdataLavishEntity)solution.getEntityList().get(0);
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntity entity4 = (TestdataLavishEntity)solution.getEntityList().get(3);
        TestdataLavishEntity entity5 = (TestdataLavishEntity)solution.getEntityList().get(4);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> a, Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((a, b, c) -> a, Function.identity()), Joiners.filtering((entityA, entityB, entityC, entityD) -> !Objects.equals(entityA, entity1))).filter((entityA, entityB, entityC, entityD) -> !Objects.equals(entityA, entity2)).filter((entityA, entityB, entityC, entityD) -> !Objects.equals(entityA, entity3)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity4, entity5, entity4, entity4));
        scoreDirector.beforeEntityRemoved((Object)entity4);
        solution.getEntityList().remove(entity4);
        scoreDirector.afterEntityRemoved((Object)entity4);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExists_unknownClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).ifExists(Integer.class, new PentaJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void ifExists_0Joiner0Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).ifExists(TestdataLavishValueGroup.class, new PentaJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishValueGroup valueGroup = solution.getFirstValueGroup();
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue(), solution.getFirstEntity()));
        scoreDirector.beforeProblemFactRemoved((Object)valueGroup);
        solution.getValueGroupList().remove(valueGroup);
        scoreDirector.afterProblemFactRemoved((Object)valueGroup);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExists_0Join1Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), (TestdataLavishValue)solution.getValueList().get(1));
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entityA, entityB, group) -> entityA.getValue(), Function.identity())).ifExists(TestdataLavishValueGroup.class, Joiners.filtering((entityA, entityB, entityAGroup, value, valueGroup) -> Objects.equals(value.getValueGroup(), valueGroup))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity2, entity1, entityGroup, solution.getFirstValue()), AbstractQuadConstraintStreamTest.assertMatch(entity2, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()), AbstractQuadConstraintStreamTest.assertMatch(entity1, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()));
        TestdataLavishValueGroup toRemove = solution.getFirstValueGroup();
        scoreDirector.beforeProblemFactRemoved((Object)toRemove);
        solution.getValueGroupList().remove(toRemove);
        scoreDirector.afterProblemFactRemoved((Object)toRemove);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExists_1Join0Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entityA, entityB, group) -> entityA.getValue(), Function.identity())).ifExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB, groupA, valueA) -> entityA.getEntityGroup(), Function.identity())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity2, entity1, entityGroup, solution.getFirstValue()), AbstractQuadConstraintStreamTest.assertMatch(entity2, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()), AbstractQuadConstraintStreamTest.assertMatch(entity1, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity2, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()), AbstractQuadConstraintStreamTest.assertMatch(entity1, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()));
    }

    @Override
    @TestTemplate
    public void ifExists_1Join1Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entityA, entityB, group) -> entityA.getValue(), Function.identity())).ifExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB, groupA, valueA) -> entityA.getEntityGroup(), Function.identity()), Joiners.filtering((entityA, entityB, groupA, valueA, groupB) -> entityA.getCode().contains("MyEntity") || groupA.getCode().contains("MyEntity"))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity2, entity1, entityGroup, solution.getFirstValue()));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    @Disabled(value="Would cause too many matches to meaningfully assert; cost-benefit ratio is wrong here.")
    public void ifExistsDoesNotIncludeNullVars() {
    }

    @Override
    @TestTemplate
    @Deprecated(forRemoval=true)
    @Disabled(value="Would cause too many matches to meaningfully assert; cost-benefit ratio is wrong here.")
    public void ifExistsIncludesNullVarsWithFrom() {
    }

    @Override
    @TestTemplate
    public void ifNotExists_unknownClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).ifNotExists(Integer.class, new PentaJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void ifNotExists_0Joiner0Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).ifNotExists(TestdataLavishValueGroup.class, new PentaJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishValueGroup valueGroup = solution.getFirstValueGroup();
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)valueGroup);
        solution.getValueGroupList().remove(valueGroup);
        scoreDirector.afterProblemFactRemoved((Object)valueGroup);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue(), solution.getFirstEntity()));
    }

    @Override
    @TestTemplate
    public void ifNotExists_0Join1Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), (TestdataLavishValue)solution.getValueList().get(1));
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entityA, entityB, group) -> entityA.getValue(), Function.identity())).ifNotExists(TestdataLavishValueGroup.class, Joiners.filtering((entityA, entityB, entityAGroup, value, valueGroup) -> Objects.equals(value.getValueGroup(), valueGroup))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        TestdataLavishValueGroup toRemove = solution.getFirstValueGroup();
        scoreDirector.beforeProblemFactRemoved((Object)toRemove);
        solution.getValueGroupList().remove(toRemove);
        scoreDirector.afterProblemFactRemoved((Object)toRemove);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity2, entity1, entityGroup, solution.getFirstValue()), AbstractQuadConstraintStreamTest.assertMatch(entity2, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()), AbstractQuadConstraintStreamTest.assertMatch(entity1, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()));
    }

    @Override
    @TestTemplate
    public void ifNotExists_1Join0Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entityA, entityB, group) -> entityA.getValue(), Function.identity())).ifNotExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB, groupA, valueA) -> entityB.getEntityGroup(), Function.identity())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, solution.getFirstEntity(), solution.getFirstEntityGroup(), solution.getFirstValue()));
    }

    @Override
    @TestTemplate
    public void ifNotExists_1Join1Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entityA, entityB, group) -> entityA.getValue(), Function.identity())).ifNotExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB, groupA, valueA) -> entityA.getEntityGroup(), Function.identity()), Joiners.filtering((entityA, entityB, groupA, valueA, groupB) -> !entityA.getCode().contains("MyEntity") || !groupB.getCode().contains("MyEntity"))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity2, entity1, entityGroup, solution.getFirstValue()));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    @Disabled(value="Would cause too many matches to meaningfully assert; cost-benefit ratio is wrong here.")
    public void ifNotExistsDoesNotIncludeNullVars() {
    }

    @Override
    @TestTemplate
    @Deprecated(forRemoval=true)
    @Disabled(value="Would cause too many matches to meaningfully assert; cost-benefit ratio is wrong here.")
    public void ifNotExistsIncludesNullVarsWithFrom() {
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy(ConstraintCollectors.countQuad()).penalize("testConstraintName", (Score)SimpleScore.ONE, count -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-5, 5));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-2, 2));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping2Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((e1, e2) -> e1, Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((e1, e2, e3) -> e2, Function.identity())).groupBy(ConstraintCollectors.countQuad(), ConstraintCollectors.countDistinct((e, e2, e3, e4) -> e)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, 3, 2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, 1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping3Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((e1, e2) -> e1, Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((e1, e2, e3) -> e2, Function.identity())).groupBy(ConstraintCollectors.countQuad(), ConstraintCollectors.min((e, e2, e3, e4) -> e.getLongProperty()), ConstraintCollectors.max((e, e2, e3, e4) -> e.getLongProperty())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(0L));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(1L));
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        entity3.setLongProperty(Long.valueOf(2L));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, 3, 0L, 1L));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, 1, 1L, 1L));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping4Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((e1, e2) -> e1, Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((e1, e2, e3) -> e2, Function.identity())).groupBy(ConstraintCollectors.countQuad(), ConstraintCollectors.min((e, e2, e3, e4) -> e.getLongProperty()), ConstraintCollectors.max((e, e2, e3, e4) -> e.getLongProperty()), ConstraintCollectors.toSet((e, e2, e3, e4) -> e)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(0L));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(1L));
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        entity3.setLongProperty(Long.valueOf(2L));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, 3, 0L, 1L, AbstractQuadConstraintStreamTest.asSet(entity1, entity2)));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, 1, 1L, 1L, AbstractQuadConstraintStreamTest.asSet(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping0Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy((entity1, group, value, entity2) -> value).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, value2), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, value1));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy((entity1, group, value, entity2) -> value, ConstraintCollectors.countQuad()).penalize("testConstraintName", (Score)SimpleScore.ONE, (group, count) -> count));
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, value2, 1), AbstractQuadConstraintStreamTest.assertMatchWithScore(-4, value1, 4));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, value2, 1), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, value1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping2Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((entityA, entityB) -> entityA, Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entityA, entityB, entityC) -> entityB, Function.identity())).groupBy((entityA, entityB, entityC, entityD) -> entityA.toString(), ConstraintCollectors.countQuad(), ConstraintCollectors.toSet((entityA, entityB, entityC, entityD) -> entityA)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity1.toString(), 2, Collections.singleton(entity1)), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), 1, Collections.singleton(entity2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), 1, Collections.singleton(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping3Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((entityA, entityB) -> entityA, Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entityA, entityB, entityC) -> entityB, Function.identity())).groupBy((entityA, entityB, entityC, entityD) -> entityA.toString(), ConstraintCollectors.min((entityA, entityB, entityC, entityD) -> entityA.getLongProperty()), ConstraintCollectors.max((entityA, entityB, entityC, entityD) -> entityA.getLongProperty()), ConstraintCollectors.toSet((entityA, entityB, entityC, entityD) -> entityA)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(Long.MAX_VALUE));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(Long.MIN_VALUE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity1.toString(), Long.MAX_VALUE, Long.MAX_VALUE, Collections.singleton(entity1)), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), Long.MIN_VALUE, Long.MIN_VALUE, Collections.singleton(entity2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), Long.MIN_VALUE, Long.MIN_VALUE, Collections.singleton(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping0Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy((entity1, group, value, entity2) -> group, (entity1, group, value, entity2) -> value).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, value2), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, value1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, value2), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, value1));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy((entity1, group, value, entity2) -> group, (entity1, group, value, entity2) -> value, ConstraintCollectors.countQuad()).penalize("testConstraintName", (Score)SimpleScore.ONE, (group, value, count) -> count));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, value2, 1), AbstractQuadConstraintStreamTest.assertMatchWithScore(-4, group1, value1, 4));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, value2, 1), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, value1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping2Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy((entity1, group, value, entity2) -> group, (entity1, group, value, entity2) -> value, ConstraintCollectors.countQuad(), ConstraintCollectors.countQuad()).penalize("testConstraintName", (Score)SimpleScore.ONE, (group, value, count, sameCount) -> count + sameCount));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-2, group2, value2, 1, 1), AbstractQuadConstraintStreamTest.assertMatchWithScore(-8, group1, value1, 4, 4));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-2, group2, value2, 1, 1), AbstractQuadConstraintStreamTest.assertMatchWithScore(-2, group1, value1, 1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_3Mapping0Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy((entity1, group, value, entity2) -> entity1.getEntityGroup(), (entity1, group, value, entity2) -> entity2.getEntityGroup(), (entity1, group, value, entity2) -> value).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, group2, value2), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, group1, value1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, value2, value2), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, value1, value1));
    }

    @Override
    @TestTemplate
    public void groupBy_3Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy((entity1, group, value, entity2) -> entity1.getEntityGroup(), (entity1, group, value, entity2) -> entity2.getEntityGroup(), (entity1, group, value, entity2) -> group, ConstraintCollectors.countQuad()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, group2, group2, 1), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, group1, group1, 4));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, group2, group2, 1), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, group1, group1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_4Mapping0Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).join(TestdataLavishEntity.class, Joiners.equal((entity, group, value) -> group, TestdataLavishEntity::getEntityGroup)).groupBy((entity1, group, value, entity2) -> entity1.getEntityGroup(), (entity1, group, value, entity2) -> entity2.getEntityGroup(), (entity1, group, value, entity2) -> group, (entity1, group, value, entity2) -> value).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, group2, group2, value2), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, group1, group1, value1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group2, group2, group2, value2), AbstractQuadConstraintStreamTest.assertMatchWithScore(-1, group1, group1, group1, value1));
    }

    @Override
    @TestTemplate
    public void distinct() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2) -> entity1.getEntityGroup(), Function.identity())).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2, group) -> entity2.getEntityGroup(), Function.identity())).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, group1, group2), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, group1, group1), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, group2, group1));
    }

    @Override
    @TestTemplate
    public void mapWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2) -> entity1.getEntityGroup(), Function.identity())).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2, group) -> entity2.getEntityGroup(), Function.identity())).map((entity1, entity2, group1, group2) -> AbstractQuadConstraintStreamTest.asSet(group1, group2)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity = solution.getFirstEntity();
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1, group2)), AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1, group2)), AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1)));
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1, group2)));
    }

    @Override
    @TestTemplate
    public void mapWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2) -> entity1.getEntityGroup(), Function.identity())).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2, group) -> entity2.getEntityGroup(), Function.identity())).map((entity1, entity2, group1, group2) -> AbstractQuadConstraintStreamTest.asSet(group1, group2)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1, group2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void mapAndDistinctWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2) -> entity1.getEntityGroup(), Function.identity())).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2, group) -> entity2.getEntityGroup(), Function.identity())).map((entity1, entity2, group1, group2) -> AbstractQuadConstraintStreamTest.asSet(group1, group2)).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity = solution.getFirstEntity();
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1, group2)), AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1)));
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1, group2)));
    }

    @Override
    @TestTemplate
    public void mapAndDistinctWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2) -> entity1.getEntityGroup(), Function.identity())).join(TestdataLavishEntityGroup.class, Joiners.equal((entity1, entity2, group) -> entity2.getEntityGroup(), Function.identity())).map((entity1, entity2, group1, group2) -> AbstractQuadConstraintStreamTest.asSet(group1, group2)).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(AbstractQuadConstraintStreamTest.asSet(group1, group2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void flattenLastWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c, d) -> a != d && b != d)).flattenLast(d -> Arrays.asList(group1, group1, group2)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group2), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group2), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group1), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group1), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void flattenLastWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c, d) -> a != d && b != d)).flattenLast(d -> Arrays.asList(group1, group2)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group2), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group2), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group1), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void flattenLastAndDistinctWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c, d) -> a != d && b != d)).flattenLast(d -> Arrays.asList(group1, group1, group2)).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group2), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group2), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group1), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void flattenLastAndDistinctWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c, d) -> a != d && b != d)).flattenLast(d -> Arrays.asList(group1, group2)).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity2, entity3, group2), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group1), AbstractQuadConstraintStreamTest.assertMatch(entity1, entity3, entity2, group2), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group1), AbstractQuadConstraintStreamTest.assertMatch(entity2, entity3, entity1, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void penalize_Int() {
        TestdataSolution solution = new TestdataSolution();
        TestdataValue v1 = new TestdataValue("v1");
        solution.setValueList(Collections.singletonList(v1));
        TestdataEntity e1 = new TestdataEntity("e1", v1);
        TestdataEntity e2 = new TestdataEntity("e2", v1);
        solution.setEntityList(Arrays.asList(e1, e2));
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataSolution.buildSolutionDescriptor(), factory -> {
            QuadConstraintStream base = factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class);
            return new Constraint[]{base.penalize("myConstraint1", (Score)SimpleScore.ONE), base.penalize("myConstraint2", (Score)SimpleScore.ONE, (entity1, entity2, value, extra) -> 20)};
        });
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)-21));
    }

    @Override
    @TestTemplate
    public void penalize_Long() {
        TestdataSimpleLongScoreSolution solution = new TestdataSimpleLongScoreSolution();
        TestdataValue v1 = new TestdataValue("v1");
        solution.setValueList(Arrays.asList(v1));
        TestdataEntity e1 = new TestdataEntity("e1", v1);
        TestdataEntity e2 = new TestdataEntity("e2", v1);
        solution.setEntityList(Arrays.asList(e1, e2));
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataSimpleLongScoreSolution.buildSolutionDescriptor(), factory -> {
            QuadConstraintStream base = factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class);
            return new Constraint[]{base.penalize("myConstraint1", (Score)SimpleLongScore.ONE), base.penalizeLong("myConstraint2", (Score)SimpleLongScore.ONE, (entity1, entity2, value, extra) -> 20L)};
        });
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThat((Comparable)((SimpleLongScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleLongScore.of((long)-21L));
    }

    @Override
    @TestTemplate
    public void penalize_BigDecimal() {
        TestdataSimpleBigDecimalScoreSolution solution = new TestdataSimpleBigDecimalScoreSolution();
        TestdataValue v1 = new TestdataValue("v1");
        solution.setValueList(Arrays.asList(v1));
        TestdataEntity e1 = new TestdataEntity("e1", v1);
        TestdataEntity e2 = new TestdataEntity("e2", v1);
        solution.setEntityList(Arrays.asList(e1, e2));
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataSimpleBigDecimalScoreSolution.buildSolutionDescriptor(), factory -> {
            QuadConstraintStream base = factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class);
            return new Constraint[]{base.penalize("myConstraint1", (Score)SimpleBigDecimalScore.ONE), base.penalizeBigDecimal("myConstraint2", (Score)SimpleBigDecimalScore.ONE, (entity1, entity2, value, extra) -> new BigDecimal("0.2"))};
        });
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThat((Comparable)((SimpleBigDecimalScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("-1.2")));
    }

    @Override
    @TestTemplate
    public void penalize_negative() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)2);
        String constraintName = "myConstraint";
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class).join(TestdataLavishValue.class).penalize(constraintName, (Score)SimpleScore.ONE, (entityA, entityB, group, value) -> -1));
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThatThrownBy(() -> scoreDirector.calculateScore()).hasMessageContaining(constraintName);
    }

    @Override
    @TestTemplate
    public void reward_Int() {
        TestdataSolution solution = new TestdataSolution();
        TestdataValue v1 = new TestdataValue("v1");
        solution.setValueList(Arrays.asList(v1));
        TestdataEntity e1 = new TestdataEntity("e1", v1);
        TestdataEntity e2 = new TestdataEntity("e2", v1);
        solution.setEntityList(Arrays.asList(e1, e2));
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataSolution.buildSolutionDescriptor(), factory -> new Constraint[]{factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class).reward("myConstraint1", (Score)SimpleScore.ONE), factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class).reward("myConstraint2", (Score)SimpleScore.ONE, (entity1, entity2, value, extra) -> 20)});
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)21));
    }

    @Override
    @TestTemplate
    public void reward_Long() {
        TestdataSimpleLongScoreSolution solution = new TestdataSimpleLongScoreSolution();
        TestdataValue v1 = new TestdataValue("v1");
        solution.setValueList(Arrays.asList(v1));
        TestdataEntity e1 = new TestdataEntity("e1", v1);
        TestdataEntity e2 = new TestdataEntity("e2", v1);
        solution.setEntityList(Arrays.asList(e1, e2));
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataSimpleLongScoreSolution.buildSolutionDescriptor(), factory -> new Constraint[]{factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class).reward("myConstraint1", (Score)SimpleLongScore.ONE), factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class).rewardLong("myConstraint2", (Score)SimpleLongScore.ONE, (entity1, entity2, value, extra) -> 20L)});
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThat((Comparable)((SimpleLongScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleLongScore.of((long)21L));
    }

    @Override
    @TestTemplate
    public void reward_BigDecimal() {
        TestdataSimpleBigDecimalScoreSolution solution = new TestdataSimpleBigDecimalScoreSolution();
        TestdataValue v1 = new TestdataValue("v1");
        solution.setValueList(Arrays.asList(v1));
        TestdataEntity e1 = new TestdataEntity("e1", v1);
        TestdataEntity e2 = new TestdataEntity("e2", v1);
        solution.setEntityList(Arrays.asList(e1, e2));
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataSimpleBigDecimalScoreSolution.buildSolutionDescriptor(), factory -> new Constraint[]{factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class).reward("myConstraint1", (Score)SimpleBigDecimalScore.ONE), factory.forEachUniquePair(TestdataEntity.class).join(TestdataValue.class, Joiners.equal((entity1, entity2) -> e1.getValue(), Function.identity())).join(TestdataValue.class).rewardBigDecimal("myConstraint2", (Score)SimpleBigDecimalScore.ONE, (entity1, entity2, value, extra) -> new BigDecimal("0.2"))});
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThat((Comparable)((SimpleBigDecimalScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)new BigDecimal("1.2")));
    }

    @Override
    @TestTemplate
    public void reward_negative() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)2);
        String constraintName = "myConstraint";
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class).join(TestdataLavishValue.class).reward(constraintName, (Score)SimpleScore.ONE, (entityA, entityB, group, value) -> -1));
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThatThrownBy(() -> scoreDirector.calculateScore()).hasMessageContaining(constraintName);
    }
}

