/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.math.BigDecimal;
import java.util.Objects;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;

final class BigDecimalWeightedScoreImpacter
implements WeightedScoreImpacter {
    private final WeightedScoreImpacter.BigDecimalImpactFunction impactFunction;

    public BigDecimalWeightedScoreImpacter(WeightedScoreImpacter.BigDecimalImpactFunction impactFunction) {
        this.impactFunction = Objects.requireNonNull(impactFunction);
    }

    @Override
    public UndoScoreImpacter impactScore(int matchWeight, JustificationsSupplier justificationsSupplier) {
        return this.impactFunction.impact(BigDecimal.valueOf(matchWeight), justificationsSupplier);
    }

    @Override
    public UndoScoreImpacter impactScore(long matchWeight, JustificationsSupplier justificationsSupplier) {
        return this.impactFunction.impact(BigDecimal.valueOf(matchWeight), justificationsSupplier);
    }

    @Override
    public UndoScoreImpacter impactScore(BigDecimal matchWeight, JustificationsSupplier justificationsSupplier) {
        return this.impactFunction.impact(matchWeight, justificationsSupplier);
    }
}

