/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.math.BigDecimal;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.SimpleBigDecimalScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataSimpleBigDecimalScoreSolution;

class SimpleBigDecimalScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataSimpleBigDecimalScoreSolution, SimpleBigDecimalScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    SimpleBigDecimalScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        SimpleBigDecimalScoreInliner scoreInliner = new SimpleBigDecimalScoreInliner(true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.ZERO);
    }

    @Test
    void impact() {
        SimpleBigDecimalScoreInliner scoreInliner = new SimpleBigDecimalScoreInliner(true);
        SimpleBigDecimalScore constraintWeight = SimpleBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(10L));
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(BigDecimal.TEN, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(100L)));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(BigDecimal.valueOf(20L), EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(300L)));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(100L)));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleBigDecimalScore.of((BigDecimal)BigDecimal.ZERO));
    }

    @Override
    protected SolutionDescriptor<TestdataSimpleBigDecimalScoreSolution> buildSolutionDescriptor() {
        return TestdataSimpleBigDecimalScoreSolution.buildSolutionDescriptor();
    }
}

