/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.uni;

import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.constraint.streams.common.bi.BiJoinerComber;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintBuilder;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;

public interface InnerUniConstraintStream<A>
extends UniConstraintStream<A> {
    public RetrievalSemantics getRetrievalSemantics();

    public boolean guaranteesDistinct();

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.join(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.join(this.getConstraintFactory().from(otherClass), joiners);
    }

    public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> var1, BiJoinerComber<A, B> var2);

    default public UniConstraintStream<A> distinct() {
        if (this.guaranteesDistinct()) {
            return this;
        }
        return this.groupBy(Function.identity());
    }

    default public UniConstraintBuilder<A> penalize(Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public UniConstraintBuilder<A> penalizeLong(Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public UniConstraintBuilder<A> penalizeBigDecimal(Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public UniConstraintBuilder<A> penalizeConfigurable(ToIntFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public UniConstraintBuilder<A> penalizeConfigurableLong(ToLongFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public UniConstraintBuilder<A> penalizeConfigurableBigDecimal(Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    default public UniConstraintBuilder<A> reward(Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public UniConstraintBuilder<A> rewardLong(Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public UniConstraintBuilder<A> rewardBigDecimal(Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    default public UniConstraintBuilder<A> rewardConfigurable(ToIntFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public UniConstraintBuilder<A> rewardConfigurableLong(ToLongFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public UniConstraintBuilder<A> rewardConfigurableBigDecimal(Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    default public UniConstraintBuilder<A> impact(Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public UniConstraintBuilder<A> impactLong(Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public UniConstraintBuilder<A> impactBigDecimal(Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    default public UniConstraintBuilder<A> impactConfigurable(ToIntFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    default public UniConstraintBuilder<A> impactConfigurableLong(ToLongFunction<A> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    default public UniConstraintBuilder<A> impactConfigurableBigDecimal(Function<A, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    public UniConstraintBuilder<A> innerImpact(Score<?> var1, ToIntFunction<A> var2, ScoreImpactType var3);

    public UniConstraintBuilder<A> innerImpact(Score<?> var1, ToLongFunction<A> var2, ScoreImpactType var3);

    public UniConstraintBuilder<A> innerImpact(Score<?> var1, Function<A, BigDecimal> var2, ScoreImpactType var3);

    default public Constraint penalize(String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    default public Constraint penalizeConfigurable(String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintName);
    }

    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    default public Constraint reward(String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    default public Constraint rewardConfigurable(String constraintName) {
        return this.rewardConfigurable().asConstraint(constraintName);
    }

    default public Constraint rewardConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    default public Constraint impact(String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintName);
    }

    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintPackage, constraintName);
    }
}

