/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintJustification;
import org.optaplanner.core.api.score.stream.DefaultConstraintJustification;

public final class JustificationsSupplier {
    private final Function<Score<?>, ConstraintJustification> constraintJustificationSupplier;
    private final Supplier<Collection<Object>> indictedObjectsSupplier;

    public static JustificationsSupplier empty() {
        return new JustificationsSupplier(x$0 -> DefaultConstraintJustification.of((Score)x$0, (Object[])new Object[0]), Collections::emptyList);
    }

    public static JustificationsSupplier of(Function<Score<?>, ConstraintJustification> constraintJustificationSupplier, Supplier<Collection<Object>> indictedObjectsSupplier) {
        return new JustificationsSupplier(constraintJustificationSupplier, indictedObjectsSupplier);
    }

    private JustificationsSupplier(Function<Score<?>, ConstraintJustification> constraintJustificationSupplier, Supplier<Collection<Object>> indictedObjectsSupplier) {
        this.constraintJustificationSupplier = Objects.requireNonNull(constraintJustificationSupplier);
        this.indictedObjectsSupplier = Objects.requireNonNull(indictedObjectsSupplier);
    }

    public ConstraintJustification createConstraintJustification(Score<?> impact) {
        return this.constraintJustificationSupplier.apply(impact);
    }

    public Collection<Object> createIndictedObjects() {
        return this.indictedObjectsSupplier.get();
    }
}

