/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.HardSoftLongScoreContext;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class HardSoftLongScoreInliner
extends AbstractScoreInliner<HardSoftLongScore> {
    private long hardScore;
    private long softScore;

    HardSoftLongScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter<HardSoftLongScore, HardSoftLongScoreContext> buildWeightedScoreImpacter(Constraint constraint, HardSoftLongScore constraintWeight) {
        this.validateConstraintWeight(constraint, constraintWeight);
        HardSoftLongScoreContext context = new HardSoftLongScoreContext(this, constraint, constraintWeight, impact -> this.hardScore += impact, impact -> this.softScore += impact);
        if (constraintWeight.getSoftScore() == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, justificationsSupplier) -> ctx.changeHardScoreBy(matchWeight, justificationsSupplier));
        }
        if (constraintWeight.getHardScore() == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, justificationsSupplier) -> ctx.changeSoftScoreBy(matchWeight, justificationsSupplier));
        }
        return WeightedScoreImpacter.of(context, (ctx, matchWeight, justificationsSupplier) -> ctx.changeScoreBy(matchWeight, justificationsSupplier));
    }

    @Override
    public HardSoftLongScore extractScore(int initScore) {
        return HardSoftLongScore.ofUninitialized((int)initScore, (long)this.hardScore, (long)this.softScore);
    }

    public String toString() {
        return HardSoftLongScore.class.getSimpleName() + " inliner";
    }
}

