/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.math.BigDecimal;
import java.util.Arrays;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.BendableBigDecimalScoreContext;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class BendableBigDecimalScoreInliner
extends AbstractScoreInliner<BendableBigDecimalScore> {
    private final BigDecimal[] hardScores;
    private final BigDecimal[] softScores;

    BendableBigDecimalScoreInliner(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    @Override
    public WeightedScoreImpacter<BendableBigDecimalScore, BendableBigDecimalScoreContext> buildWeightedScoreImpacter(Constraint constraint, BendableBigDecimalScore constraintWeight) {
        this.validateConstraintWeight(constraint, constraintWeight);
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if (constraintWeight.getHardOrSoftScore(i).equals(BigDecimal.ZERO)) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        BendableBigDecimalScoreContext.IntBigDecimalConsumer hardScoreUpdater = (scoreLevel, impact) -> {
            this.hardScores[scoreLevel] = this.hardScores[scoreLevel].add(impact);
        };
        BendableBigDecimalScoreContext.IntBigDecimalConsumer softScoreUpdater = (scoreLevel, impact) -> {
            this.softScores[scoreLevel] = this.softScores[scoreLevel].add(impact);
        };
        if (singleLevel != null) {
            boolean isHardScore = singleLevel < constraintWeight.getHardLevelsSize();
            int level = isHardScore ? singleLevel : singleLevel - constraintWeight.getHardLevelsSize();
            BendableBigDecimalScoreContext context = new BendableBigDecimalScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, level, constraintWeight.getHardOrSoftScore(singleLevel.intValue()), hardScoreUpdater, softScoreUpdater);
            if (isHardScore) {
                return WeightedScoreImpacter.of(context, BendableBigDecimalScoreContext::changeHardScoreBy);
            }
            return WeightedScoreImpacter.of(context, BendableBigDecimalScoreContext::changeSoftScoreBy);
        }
        BendableBigDecimalScoreContext context = new BendableBigDecimalScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, hardScoreUpdater, softScoreUpdater);
        return WeightedScoreImpacter.of(context, BendableBigDecimalScoreContext::changeScoreBy);
    }

    @Override
    public BendableBigDecimalScore extractScore(int initScore) {
        return BendableBigDecimalScore.ofUninitialized((int)initScore, (BigDecimal[])Arrays.copyOf(this.hardScores, this.hardScores.length), (BigDecimal[])Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

