/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Arrays;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.BendableScoreContext;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class BendableScoreInliner
extends AbstractScoreInliner<BendableScore> {
    private final int[] hardScores;
    private final int[] softScores;

    BendableScoreInliner(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    @Override
    public WeightedScoreImpacter<BendableScore, BendableScoreContext> buildWeightedScoreImpacter(Constraint constraint, BendableScore constraintWeight) {
        this.validateConstraintWeight(constraint, constraintWeight);
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if ((long)constraintWeight.getHardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        BendableScoreContext.IntBiConsumer hardScoreUpdater = (scoreLevel, impact) -> {
            int n = scoreLevel;
            this.hardScores[n] = this.hardScores[n] + impact;
        };
        BendableScoreContext.IntBiConsumer softScoreUpdater = (scoreLevel, impact) -> {
            int n = scoreLevel;
            this.softScores[n] = this.softScores[n] + impact;
        };
        if (singleLevel != null) {
            boolean isHardScore = singleLevel < constraintWeight.getHardLevelsSize();
            int level = isHardScore ? singleLevel : singleLevel - constraintWeight.getHardLevelsSize();
            BendableScoreContext context = new BendableScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, level, constraintWeight.getHardOrSoftScore(singleLevel.intValue()), hardScoreUpdater, softScoreUpdater);
            if (isHardScore) {
                return WeightedScoreImpacter.of(context, BendableScoreContext::changeHardScoreBy);
            }
            return WeightedScoreImpacter.of(context, BendableScoreContext::changeSoftScoreBy);
        }
        BendableScoreContext context = new BendableScoreContext(this, constraint, constraintWeight, this.hardScores.length, this.softScores.length, hardScoreUpdater, softScoreUpdater);
        return WeightedScoreImpacter.of(context, BendableScoreContext::changeScoreBy);
    }

    @Override
    public BendableScore extractScore(int initScore) {
        return BendableScore.ofUninitialized((int)initScore, (int[])Arrays.copyOf(this.hardScores, this.hardScores.length), (int[])Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableScore.class.getSimpleName() + " inliner";
    }
}

