/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.function.LongConsumer;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.ScoreContext;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class HardSoftLongScoreContext
extends ScoreContext<HardSoftLongScore> {
    private final LongConsumer softScoreUpdater;
    private final LongConsumer hardScoreUpdater;

    public HardSoftLongScoreContext(AbstractScoreInliner<HardSoftLongScore> parent, Constraint constraint, HardSoftLongScore constraintWeight, LongConsumer hardScoreUpdater, LongConsumer softScoreUpdater) {
        super(parent, constraint, constraintWeight);
        this.softScoreUpdater = softScoreUpdater;
        this.hardScoreUpdater = hardScoreUpdater;
    }

    public UndoScoreImpacter changeSoftScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long softImpact = ((HardSoftLongScore)this.constraintWeight).getSoftScore() * matchWeight;
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreUpdater.accept(-softImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftLongScore.ofSoft((long)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long hardImpact = ((HardSoftLongScore)this.constraintWeight).getHardScore() * matchWeight;
        this.hardScoreUpdater.accept(hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreUpdater.accept(-hardImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftLongScore.ofHard((long)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long hardImpact = ((HardSoftLongScore)this.constraintWeight).getHardScore() * matchWeight;
        long softImpact = ((HardSoftLongScore)this.constraintWeight).getSoftScore() * matchWeight;
        this.hardScoreUpdater.accept(hardImpact);
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> {
            this.hardScoreUpdater.accept(-hardImpact);
            this.softScoreUpdater.accept(-softImpact);
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardSoftLongScore.of((long)hardImpact, (long)softImpact), justificationsSupplier);
    }
}

