/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.function.LongConsumer;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.ScoreContext;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.stream.Constraint;

final class HardMediumSoftLongScoreContext
extends ScoreContext<HardMediumSoftLongScore> {
    private final LongConsumer softScoreUpdater;
    private final LongConsumer mediumScoreUpdater;
    private final LongConsumer hardScoreUpdater;

    public HardMediumSoftLongScoreContext(AbstractScoreInliner<HardMediumSoftLongScore> parent, Constraint constraint, HardMediumSoftLongScore constraintWeight, LongConsumer hardScoreUpdater, LongConsumer mediumScoreUpdater, LongConsumer softScoreUpdater) {
        super(parent, constraint, constraintWeight);
        this.softScoreUpdater = softScoreUpdater;
        this.mediumScoreUpdater = mediumScoreUpdater;
        this.hardScoreUpdater = hardScoreUpdater;
    }

    public UndoScoreImpacter changeSoftScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long softImpact = ((HardMediumSoftLongScore)this.constraintWeight).getSoftScore() * matchWeight;
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.softScoreUpdater.accept(-softImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftLongScore.ofSoft((long)softImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeMediumScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long mediumImpact = ((HardMediumSoftLongScore)this.constraintWeight).mediumScore() * matchWeight;
        this.mediumScoreUpdater.accept(mediumImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.mediumScoreUpdater.accept(-mediumImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftLongScore.ofMedium((long)mediumImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeHardScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long hardImpact = ((HardMediumSoftLongScore)this.constraintWeight).hardScore() * matchWeight;
        this.hardScoreUpdater.accept(hardImpact);
        UndoScoreImpacter undoScoreImpact = () -> this.hardScoreUpdater.accept(-hardImpact);
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftLongScore.ofHard((long)hardImpact), justificationsSupplier);
    }

    public UndoScoreImpacter changeScoreBy(long matchWeight, JustificationsSupplier justificationsSupplier) {
        long hardImpact = ((HardMediumSoftLongScore)this.constraintWeight).hardScore() * matchWeight;
        long mediumImpact = ((HardMediumSoftLongScore)this.constraintWeight).mediumScore() * matchWeight;
        long softImpact = ((HardMediumSoftLongScore)this.constraintWeight).getSoftScore() * matchWeight;
        this.hardScoreUpdater.accept(hardImpact);
        this.mediumScoreUpdater.accept(mediumImpact);
        this.softScoreUpdater.accept(softImpact);
        UndoScoreImpacter undoScoreImpact = () -> {
            this.hardScoreUpdater.accept(-hardImpact);
            this.mediumScoreUpdater.accept(-mediumImpact);
            this.softScoreUpdater.accept(-softImpact);
        };
        if (!this.constraintMatchEnabled) {
            return undoScoreImpact;
        }
        return this.impactWithConstraintMatch(undoScoreImpact, HardMediumSoftLongScore.of((long)hardImpact, (long)mediumImpact, (long)softImpact), justificationsSupplier);
    }
}

