/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.impl.score.stream.JoinerType;

class JoinerTypeTest {
    JoinerTypeTest() {
    }

    @Test
    void equal() {
        Assertions.assertThat((boolean)JoinerType.EQUAL.matches((Object)1, (Object)1)).isTrue();
        Assertions.assertThat((boolean)JoinerType.EQUAL.matches((Object)1, (Object)2)).isFalse();
        Assertions.assertThat((boolean)JoinerType.EQUAL.matches((Object)1, null)).isFalse();
        Assertions.assertThat((boolean)JoinerType.EQUAL.matches(null, (Object)1)).isFalse();
    }

    @Test
    void lessThan() {
        Assertions.assertThat((boolean)JoinerType.LESS_THAN.matches((Object)1, (Object)1)).isFalse();
        Assertions.assertThat((boolean)JoinerType.LESS_THAN.matches((Object)1, (Object)2)).isTrue();
        Assertions.assertThat((boolean)JoinerType.LESS_THAN.matches((Object)2, (Object)1)).isFalse();
    }

    @Test
    void lessThanOrEquals() {
        Assertions.assertThat((boolean)JoinerType.LESS_THAN_OR_EQUAL.matches((Object)1, (Object)1)).isTrue();
        Assertions.assertThat((boolean)JoinerType.LESS_THAN_OR_EQUAL.matches((Object)1, (Object)2)).isTrue();
        Assertions.assertThat((boolean)JoinerType.LESS_THAN_OR_EQUAL.matches((Object)2, (Object)1)).isFalse();
    }

    @Test
    void greaterThan() {
        Assertions.assertThat((boolean)JoinerType.GREATER_THAN.matches((Object)1, (Object)1)).isFalse();
        Assertions.assertThat((boolean)JoinerType.GREATER_THAN.matches((Object)2, (Object)1)).isTrue();
        Assertions.assertThat((boolean)JoinerType.GREATER_THAN.matches((Object)1, (Object)2)).isFalse();
    }

    @Test
    void greaterThanOrEquals() {
        Assertions.assertThat((boolean)JoinerType.GREATER_THAN_OR_EQUAL.matches((Object)1, (Object)1)).isTrue();
        Assertions.assertThat((boolean)JoinerType.GREATER_THAN_OR_EQUAL.matches((Object)2, (Object)1)).isTrue();
        Assertions.assertThat((boolean)JoinerType.GREATER_THAN_OR_EQUAL.matches((Object)1, (Object)2)).isFalse();
    }

    @Test
    void containing() {
        List<Integer> collection = Arrays.asList(1);
        Assertions.assertThat((boolean)JoinerType.CONTAINING.matches(collection, (Object)1)).isTrue();
        Assertions.assertThat((boolean)JoinerType.CONTAINING.matches(collection, (Object)2)).isFalse();
    }

    @Test
    void intersecting() {
        List<Integer> left = Arrays.asList(1, 2, 3);
        List<Integer> right = Arrays.asList(3, 4, 5);
        Assertions.assertThat((boolean)JoinerType.INTERSECTING.matches(left, right)).isTrue();
        Assertions.assertThat((boolean)JoinerType.INTERSECTING.matches(right, left)).isTrue();
        Assertions.assertThat((boolean)JoinerType.INTERSECTING.matches(left, Collections.emptySet())).isFalse();
    }

    @Test
    void disjoint() {
        List<Integer> first = Arrays.asList(1, 2, 3);
        List<Integer> second = Arrays.asList(3, 4, 5);
        Assertions.assertThat((boolean)JoinerType.DISJOINT.matches(first, second)).isFalse();
        Assertions.assertThat((boolean)JoinerType.DISJOINT.matches(second, first)).isFalse();
        List<Integer> third = Arrays.asList(4, 5);
        Assertions.assertThat((boolean)JoinerType.DISJOINT.matches(first, third)).isTrue();
        Assertions.assertThat((boolean)JoinerType.DISJOINT.matches(third, first)).isTrue();
        Assertions.assertThat((boolean)JoinerType.DISJOINT.matches(Collections.emptyList(), Collections.emptySet())).isTrue();
        Assertions.assertThat((boolean)JoinerType.DISJOINT.matches(first, Collections.emptySet())).isTrue();
    }
}

