/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.SimpleScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

class SimpleScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataSolution, SimpleScore> {
    SimpleScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        SimpleScoreInliner scoreInliner = new SimpleScoreInliner(true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.ZERO);
    }

    @Test
    void impact() {
        SimpleScoreInliner scoreInliner = new SimpleScoreInliner(true);
        SimpleScore constraintWeight = SimpleScore.of((int)10);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)100));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)300));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)100));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)0));
    }

    @Override
    protected SolutionDescriptor<TestdataSolution> buildSolutionDescriptor() {
        return TestdataSolution.buildSolutionDescriptor();
    }
}

