/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.HardMediumSoftScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataHardMediumSoftScoreSolution;

class HardMediumSoftScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataHardMediumSoftScoreSolution, HardMediumSoftScore> {
    HardMediumSoftScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.ZERO);
    }

    @Test
    void impactHard() {
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(true);
        HardMediumSoftScore constraintWeight = HardMediumSoftScore.ofHard((int)90);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)90, (int)0, (int)0));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)270, (int)0, (int)0));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)90, (int)0, (int)0));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)0));
    }

    @Test
    void impactMedium() {
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(true);
        HardMediumSoftScore constraintWeight = HardMediumSoftScore.ofMedium((int)90);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)90, (int)0));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)270, (int)0));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)90, (int)0));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)0));
    }

    @Test
    void impactSoft() {
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(true);
        HardMediumSoftScore constraintWeight = HardMediumSoftScore.ofSoft((int)90);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)90));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)270));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)90));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)0));
    }

    @Test
    void impactAll() {
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(true);
        HardMediumSoftScore constraintWeight = HardMediumSoftScore.of((int)10, (int)100, (int)1000);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)100, (int)1000, (int)10000));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)300, (int)3000, (int)30000));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)100, (int)1000, (int)10000));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)0));
    }

    @Override
    protected SolutionDescriptor<TestdataHardMediumSoftScoreSolution> buildSolutionDescriptor() {
        return TestdataHardMediumSoftScoreSolution.buildSolutionDescriptor();
    }
}

