/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.tri;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.TestTemplate;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamTest;
import org.optaplanner.constraint.streams.common.ConstraintStreamFunctionalTest;
import org.optaplanner.constraint.streams.common.ConstraintStreamImplSupport;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintJustification;
import org.optaplanner.core.api.score.stream.DefaultConstraintJustification;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataObject;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntity;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntityGroup;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishExtra;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishSolution;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValue;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValueGroup;

public abstract class AbstractTriConstraintStreamTest
extends AbstractConstraintStreamTest
implements ConstraintStreamFunctionalTest {
    protected AbstractTriConstraintStreamTest(ConstraintStreamImplSupport implSupport) {
        super(implSupport);
    }

    @Override
    @TestTemplate
    public void filter_entity() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity3);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        solution.getExtraList().add(extra2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.equal(TestdataLavishEntity::getValue, Function.identity())).join(TestdataLavishExtra.class).filter((entity, value, extra) -> value.getCode().equals("MyValue 1") && extra.getCode().equals("MyExtra 1")).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, value1, extra1), AbstractTriConstraintStreamTest.assertMatch(entity3, value1, extra1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity3);
        entity3.setValue(value2);
        scoreDirector.afterProblemPropertyChanged((Object)entity3);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, value1, extra1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setValue(value1);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, value1, extra1), AbstractTriConstraintStreamTest.assertMatch(entity2, value1, extra1));
    }

    @Override
    @TestTemplate
    public void filter_consecutive() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)5, (int)5);
        TestdataLavishEntity entity1 = (TestdataLavishEntity)solution.getEntityList().get(0);
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntity entity4 = (TestdataLavishEntity)solution.getEntityList().get(3);
        TestdataLavishEntity entity5 = (TestdataLavishEntity)solution.getEntityList().get(4);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> a, Function.identity()), Joiners.filtering((entityA, entityB, entityC) -> !Objects.equals(entityA, entity1))).filter((entityA, entityB, entityC) -> !Objects.equals(entityA, entity1)).filter((entityA, entityB, entityC) -> !Objects.equals(entityA, entity2)).filter((entityA, entityB, entityC) -> !Objects.equals(entityA, entity3)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity4, entity5, entity4));
        scoreDirector.beforeEntityRemoved((Object)entity4);
        solution.getEntityList().remove(entity4);
        scoreDirector.afterEntityRemoved((Object)entity4);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void join_0() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), value2);
        solution.getEntityList().add(entity3);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        solution.getExtraList().add(extra2);
        TestdataLavishExtra extra3 = new TestdataLavishExtra("MyExtra 3");
        solution.getExtraList().add(extra3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> Stream.of(entity1, entity2, entity3).filter(entity -> !Objects.equals(entity, a)).filter(entity -> !Objects.equals(entity, b)).map(TestdataObject::getCode).findFirst().orElseThrow(IllegalStateException::new), TestdataObject::getCode)).join(TestdataLavishExtra.class).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, entity3, extra1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, entity3, extra2), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, entity3, extra3), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, entity2, extra1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, entity2, extra2), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, entity2, extra3), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, entity1, extra1), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, entity1, extra2), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, entity1, extra3));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void join_1Equal() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        entity1.setStringProperty("MyString");
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        entity2.setStringProperty(null);
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), value2);
        entity3.setStringProperty(null);
        solution.getEntityList().add(entity3);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        extra1.setStringProperty("MyString");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        extra2.setStringProperty(null);
        solution.getExtraList().add(extra2);
        TestdataLavishExtra extra3 = new TestdataLavishExtra("MyExtra 3");
        extra3.setStringProperty("MyString");
        solution.getExtraList().add(extra3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> Stream.of(entity1, entity2, entity3).filter(entity -> !Objects.equals(entity, a)).filter(entity -> !Objects.equals(entity, b)).map(TestdataObject::getCode).findFirst().orElseThrow(IllegalStateException::new), TestdataObject::getCode)).join(TestdataLavishExtra.class, Joiners.equal((e1, e2, e3) -> e1.getStringProperty(), TestdataLavishExtra::getStringProperty)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, entity3, extra1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, entity3, extra3), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, entity2, extra1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, entity2, extra3), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, entity1, extra2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void join_2Equal() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        entity1.setStringProperty("MyString");
        entity1.setIntegerProperty(Integer.valueOf(7));
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        entity2.setStringProperty(null);
        entity2.setIntegerProperty(Integer.valueOf(8));
        solution.getEntityList().add(entity2);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        extra1.setStringProperty("MyString");
        extra1.setIntegerProperty(Integer.valueOf(8));
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        extra2.setStringProperty(null);
        extra2.setIntegerProperty(Integer.valueOf(7));
        solution.getExtraList().add(extra2);
        TestdataLavishExtra extra3 = new TestdataLavishExtra("MyExtra 3");
        extra3.setStringProperty("MyString");
        extra3.setIntegerProperty(Integer.valueOf(7));
        solution.getExtraList().add(extra3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.equal((e1, e2) -> e1.getValue(), Function.identity())).join(TestdataLavishExtra.class, Joiners.equal((e1, e2, value) -> e1.getStringProperty(), TestdataLavishExtra::getStringProperty), Joiners.equal((e1, e2, value) -> e1.getIntegerProperty(), TestdataLavishExtra::getIntegerProperty)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, value1, extra3));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void joinAfterGroupBy() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity2);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        solution.getExtraList().add(extra2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(ConstraintCollectors.countDistinct(TestdataLavishEntity::getValue), ConstraintCollectors.countDistinct(TestdataLavishEntity::getValue), ConstraintCollectors.countDistinct(TestdataLavishEntity::getValue)).join(TestdataLavishExtra.class).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(1, 1, 1, extra1), AbstractTriConstraintStreamTest.assertMatch(1, 1, 1, extra2));
        scoreDirector.beforeVariableChanged((Object)entity2, "value");
        entity2.setValue(value2);
        scoreDirector.afterVariableChanged((Object)entity2, "value");
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(2, 2, 2, extra1), AbstractTriConstraintStreamTest.assertMatch(2, 2, 2, extra2));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(1, 1, 1, extra1), AbstractTriConstraintStreamTest.assertMatch(1, 1, 1, extra2));
    }

    @Override
    @TestTemplate
    public void ifExists_unknownClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishValueGroup.class).join(TestdataLavishEntityGroup.class).ifExists(Integer.class, new QuadJoiner[0]).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void ifExists_0Joiner0Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishValueGroup valueGroup = new TestdataLavishValueGroup("MyValueGroup");
        solution.getValueGroupList().add(valueGroup);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishValueGroup.class).join(TestdataLavishEntityGroup.class).ifExists(TestdataLavishEntity.class, new QuadJoiner[0]).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(valueGroup, solution.getFirstValueGroup(), solution.getFirstEntityGroup()));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityGroupList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExists_0Join1Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> !Objects.equals(entityC, entityA) && !Objects.equals(entityC, entityB))).ifExists(TestdataLavishEntityGroup.class, Joiners.filtering((entityA, entityB, entityC, group) -> Objects.equals(group, entityA.getEntityGroup()) && Objects.equals(group, entityB.getEntityGroup()))).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
        TestdataLavishEntityGroup toRemove = solution.getFirstEntityGroup();
        scoreDirector.beforeProblemFactRemoved((Object)toRemove);
        solution.getEntityGroupList().remove(toRemove);
        scoreDirector.afterProblemFactRemoved((Object)toRemove);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExists_1Join0Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> !Objects.equals(entityC, entityA) && !Objects.equals(entityC, entityB))).ifExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB, entityC) -> entityA.getEntityGroup(), Function.identity())).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity2, entity1, solution.getFirstEntity()), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()), AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1, entity2));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity2, entity1, solution.getFirstEntity()), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
    }

    @Override
    @TestTemplate
    public void ifExists_1Join1Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> !Objects.equals(entityC, entityA) && !Objects.equals(entityC, entityB))).ifExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB, entityC) -> entityA.getEntityGroup(), Function.identity()), Joiners.filtering((entityA, entityB, entityC, group) -> entityA.getCode().contains("MyEntity") || group.getCode().contains("MyEntity"))).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2, entity1));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExistsDoesNotIncludeNullVars() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("Entity with null var", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> entityA != entityC && entityB != entityC)).ifExists(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC, entityD) -> entityA != entityD && entityB != entityD && entityC != entityD)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    @Deprecated(forRemoval=true)
    public void ifExistsIncludesNullVarsWithFrom() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("Entity with null var", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.fromUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> entityA != entityC && entityB != entityC)).ifExists(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC, entityD) -> entityA != entityD && entityB != entityD && entityC != entityD)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1, entity2), AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2, entity1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
        scoreDirector.beforeProblemFactRemoved((Object)entity3);
        solution.getEntityList().remove(entity3);
        scoreDirector.afterProblemFactRemoved((Object)entity3);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifNotExists_unknownClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishValueGroup.class).join(TestdataLavishEntityGroup.class).ifNotExists(Integer.class, new QuadJoiner[0]).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void ifNotExists_0Joiner0Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishValueGroup valueGroup = new TestdataLavishValueGroup("MyValueGroup");
        solution.getValueGroupList().add(valueGroup);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishValueGroup.class).join(TestdataLavishEntityGroup.class).ifNotExists(TestdataLavishEntity.class, new QuadJoiner[0]).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityGroupList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(valueGroup, solution.getFirstValueGroup(), solution.getFirstEntityGroup()));
    }

    @Override
    @TestTemplate
    public void ifNotExists_0Join1Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> !Objects.equals(entityC, entityA) && !Objects.equals(entityC, entityB))).ifNotExists(TestdataLavishEntityGroup.class, Joiners.filtering((entityA, entityB, entityC, group) -> Objects.equals(group, entityA.getEntityGroup()) && Objects.equals(group, entityB.getEntityGroup()))).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity2, entity1, solution.getFirstEntity()), AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1, entity2));
        TestdataLavishEntityGroup toRemove = solution.getFirstEntityGroup();
        scoreDirector.beforeProblemFactRemoved((Object)toRemove);
        solution.getEntityGroupList().remove(toRemove);
        scoreDirector.afterProblemFactRemoved((Object)toRemove);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity2, entity1, solution.getFirstEntity()), AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2, entity1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
    }

    @Override
    @TestTemplate
    public void ifNotExists_1Join0Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> !Objects.equals(entityC, entityA) && !Objects.equals(entityC, entityB))).ifNotExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB, entityC) -> entityA.getEntityGroup(), Function.identity())).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity2, entity1, solution.getFirstEntity()));
    }

    @Override
    @TestTemplate
    public void ifNotExists_1Join1Filter() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> !Objects.equals(entityC, entityA) && !Objects.equals(entityC, entityB))).ifNotExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB, entityC) -> entityA.getEntityGroup(), Function.identity()), Joiners.filtering((entityA, entityB, entityC, group) -> entityA.getCode().contains("MyEntity") || group.getCode().contains("MyEntity"))).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity2, entity1, solution.getFirstEntity()), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity2, entity1, solution.getFirstEntity()), AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2, entity1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
    }

    @Override
    @TestTemplate
    public void ifNotExistsDoesNotIncludeNullVars() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("Entity with null var", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> entityA != entityC && entityB != entityC)).ifNotExists(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC, entityD) -> entityA != entityD && entityB != entityD && entityC != entityD)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1, entity2), AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2, entity1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
        scoreDirector.beforeProblemFactRemoved((Object)entity3);
        solution.getEntityList().remove(entity3);
        scoreDirector.afterProblemFactRemoved((Object)entity3);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1, entity2), AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2, entity1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
    }

    @Override
    @TestTemplate
    @Deprecated(forRemoval=true)
    public void ifNotExistsIncludesNullVarsWithFrom() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("Entity with null var", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.fromUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC) -> entityA != entityC && entityB != entityC)).ifNotExists(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB, entityC, entityD) -> entityA != entityD && entityB != entityD && entityC != entityD)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)entity3);
        solution.getEntityList().remove(entity3);
        scoreDirector.afterProblemFactRemoved((Object)entity3);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1, entity2), AbstractTriConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2, entity1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, solution.getFirstEntity()));
    }

    @Override
    @TestTemplate
    public void ifExistsAfterGroupBy() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity2);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        solution.getExtraList().add(extra2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(ConstraintCollectors.countDistinct(TestdataLavishEntity::getValue), ConstraintCollectors.countDistinct(TestdataLavishEntity::getValue), ConstraintCollectors.countDistinct(TestdataLavishEntity::getValue)).ifExists(TestdataLavishExtra.class, new QuadJoiner[0]).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(1, 1, 1));
        scoreDirector.beforeVariableChanged((Object)entity2, "value");
        entity2.setValue(value2);
        scoreDirector.afterVariableChanged((Object)entity2, "value");
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(2, 2, 2));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(1, 1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).groupBy(ConstraintCollectors.countTri()).penalize((Score)SimpleScore.ONE, count -> count).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-3, 3));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-2, 2));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping2Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((e1, e2) -> e1, Function.identity())).groupBy(ConstraintCollectors.countTri(), ConstraintCollectors.countDistinct((e, e2, e3) -> e)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, 3, 2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, 1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping3Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((e1, e2) -> e1, Function.identity())).groupBy(ConstraintCollectors.countTri(), ConstraintCollectors.min((e, e2, e3) -> e.getLongProperty()), ConstraintCollectors.max((e, e2, e3) -> e.getLongProperty())).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(0L));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(1L));
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        entity3.setLongProperty(Long.valueOf(2L));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, 3, 0L, 1L));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, 1, 1L, 1L));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping4Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((e1, e2) -> e1, Function.identity())).groupBy(ConstraintCollectors.countTri(), ConstraintCollectors.min((e, e2, e3) -> e.getLongProperty()), ConstraintCollectors.max((e, e2, e3) -> e.getLongProperty()), ConstraintCollectors.toSet((e, e2, e3) -> e)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(0L));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(1L));
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        entity3.setLongProperty(Long.valueOf(2L));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, 3, 0L, 1L, AbstractTriConstraintStreamTest.asSet(entity1, entity2)));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, 1, 1L, 1L, AbstractTriConstraintStreamTest.asSet(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping0Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).groupBy((entity, group, value) -> value).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, value2), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, value1));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).groupBy((entity, group, value) -> value, ConstraintCollectors.countTri()).penalize((Score)SimpleScore.ONE, (group, count) -> count).asConstraint("testConstraintName"));
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, value2, 1), AbstractTriConstraintStreamTest.assertMatchWithScore(-2, value1, 2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, value2, 1), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, value1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping2Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((entityA, entityB) -> entityA, Function.identity())).groupBy((entityA, entityB, entityC) -> entityA.toString(), ConstraintCollectors.countTri(), ConstraintCollectors.toSet((entityA, entityB, entityC) -> entityA)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity1.toString(), 2, Collections.singleton(entity1)), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), 1, Collections.singleton(entity2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), 1, Collections.singleton(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping3Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal((entityA, entityB) -> entityA, Function.identity())).groupBy((entityA, entityB, entityC) -> entityA.toString(), ConstraintCollectors.min((entityA, entityB, entityC) -> entityA.getLongProperty()), ConstraintCollectors.max((entityA, entityB, entityC) -> entityA.getLongProperty()), ConstraintCollectors.toSet((entityA, entityB, entityC) -> entityA)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(Long.MAX_VALUE));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(Long.MIN_VALUE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity1.toString(), Long.MAX_VALUE, Long.MAX_VALUE, Collections.singleton(entity1)), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), Long.MIN_VALUE, Long.MIN_VALUE, Collections.singleton(entity2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), Long.MIN_VALUE, Long.MIN_VALUE, Collections.singleton(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping0Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).groupBy((entity, group, value) -> group, (entity, group, value) -> value).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group2, value2), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, value1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group2, value2), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, value1));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).groupBy((entity, group, value) -> group, (entity, group, value) -> value, ConstraintCollectors.countTri()).penalize((Score)SimpleScore.ONE, (group, value, count) -> count).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group2, value2, 1), AbstractTriConstraintStreamTest.assertMatchWithScore(-2, group1, value1, 2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group2, value2, 1), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, value1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping2Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).join(TestdataLavishValue.class, Joiners.equal((entity, group) -> entity.getValue(), Function.identity())).groupBy((entity, group, value) -> group, (entity, group, value) -> value, ConstraintCollectors.countTri(), ConstraintCollectors.countTri()).penalize((Score)SimpleScore.ONE, (group, value, count, sameCount) -> count + sameCount).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-2, group2, value2, 1, 1), AbstractTriConstraintStreamTest.assertMatchWithScore(-4, group1, value1, 2, 2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-2, group2, value2, 1, 1), AbstractTriConstraintStreamTest.assertMatchWithScore(-2, group1, value1, 1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_3Mapping0Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).groupBy((a, b, c) -> a.getEntityGroup(), (a, b, c) -> b.getEntityGroup(), (a, b, c) -> c.getEntityGroup()).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(0);
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, group2, group3), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, group3, group2), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group2, group3, group1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void groupBy_3Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).groupBy((a, b, c) -> a.getEntityGroup(), (a, b, c) -> b.getEntityGroup(), (a, b, c) -> c.getEntityGroup(), ConstraintCollectors.countTri()).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(0);
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, group2, group3, 1), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, group3, group2, 1), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group2, group3, group1, 1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void groupBy_4Mapping0Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).groupBy((a, b, c) -> a.getEntityGroup(), (a, b, c) -> b.getEntityGroup(), (a, b, c) -> c.getEntityGroup(), (a, b, c) -> a.getValue()).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(0);
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        TestdataLavishValue value1 = (TestdataLavishValue)solution.getValueList().get(0);
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, group2, group3, value1), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group1, group3, group2, value2), AbstractTriConstraintStreamTest.assertMatchWithScore(-1, group2, group3, group1, value1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void distinct() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).distinct().penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, entity3), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, entity2), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, entity1));
    }

    @Override
    @TestTemplate
    public void mapWithDuplicates() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).map((a, b, c) -> AbstractTriConstraintStreamTest.asSet(a.getEntityGroup(), b.getEntityGroup(), c.getEntityGroup())).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group1, group2)), AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group1, group2)), AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group1, group2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void mapWithoutDuplicates() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).map((a, b, c) -> AbstractTriConstraintStreamTest.asSet(a.getEntityGroup(), b.getEntityGroup())).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group1, group2)), AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group1, group3)), AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group2, group3)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void mapAndDistinctWithDuplicates() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).map((a, b, c) -> AbstractTriConstraintStreamTest.asSet(a.getEntityGroup(), b.getEntityGroup(), c.getEntityGroup())).distinct().penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group1, group2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void mapAndDistinctWithoutDuplicates() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).map((a, b, c) -> AbstractTriConstraintStreamTest.asSet(a.getEntityGroup(), b.getEntityGroup())).distinct().penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group1, group2)), AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group1, group3)), AbstractTriConstraintStreamTest.assertMatch(AbstractTriConstraintStreamTest.asSet(group2, group3)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void flattenLastWithDuplicates() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).flattenLast(c -> Arrays.asList(c.getEntityGroup(), group1, group2)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group2), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group2), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group2), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void flattenLastWithoutDuplicates() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).flattenLast(c -> AbstractTriConstraintStreamTest.asSet(c.getEntityGroup(), c.getEntityGroup() == group1 ? group2 : group1)).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group2), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group2), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void flattenLastAndDistinctWithDuplicates() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).flattenLast(c -> Arrays.asList(c.getEntityGroup(), group1, group2)).distinct().penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group2), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group2), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void flattenLastAndDistinctWithoutDuplicates() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).flattenLast(c -> AbstractTriConstraintStreamTest.asSet(c.getEntityGroup(), c.getEntityGroup() == group1 ? group2 : group1)).distinct().penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity2, group2), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity1, entity3, group2), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group1), AbstractTriConstraintStreamTest.assertMatch(entity2, entity3, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void penalizeUnweighted() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).penalize((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)-2));
        this.assertDefaultJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    private <Score_ extends Score<Score_>, Solution_, Entity_, Value_> void assertDefaultJustifications(InnerScoreDirector<Solution_, Score_> scoreDirector, List<Entity_> entityList, List<Value_> valueList) {
        if (!this.implSupport.isConstreamMatchEnabled()) {
            return;
        }
        Assertions.assertThat((Map)scoreDirector.getIndictmentMap()).containsOnlyKeys(new Object[]{entityList.get(0), entityList.get(1), entityList.get(5), entityList.get(6), valueList.get(0), valueList.get(1)});
        String constraintFqn = ConstraintMatchTotal.composeConstraintId((String)scoreDirector.getSolutionDescriptor().getSolutionClass().getPackageName(), (String)"testConstraintName");
        Map constraintMatchTotalMap = scoreDirector.getConstraintMatchTotalMap();
        Assertions.assertThat((Map)constraintMatchTotalMap).containsOnlyKeys((Object[])new String[]{constraintFqn});
        ConstraintMatchTotal constraintMatchTotal = (ConstraintMatchTotal)constraintMatchTotalMap.get(constraintFqn);
        Assertions.assertThat((Collection)constraintMatchTotal.getConstraintMatchSet()).hasSize(2);
        ArrayList constraintMatchList = new ArrayList(constraintMatchTotal.getConstraintMatchSet());
        for (int i = 0; i < 2; ++i) {
            ConstraintMatch constraintMatch = (ConstraintMatch)constraintMatchList.get(i);
            SoftAssertions.assertSoftly(softly -> {
                ConstraintJustification justification = constraintMatch.getJustification();
                softly.assertThat((Object)justification).isInstanceOf(DefaultConstraintJustification.class);
                DefaultConstraintJustification castJustification = (DefaultConstraintJustification)justification;
                softly.assertThat(castJustification.getFacts()).hasSize(3);
                softly.assertThat(constraintMatch.getIndictedObjectList()).hasSize(3);
            });
        }
    }

    @Override
    @TestTemplate
    public void penalize() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).penalize((Score)SimpleScore.ONE, (entity, entity2, value) -> 2).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)-4));
        this.assertDefaultJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalizeLong() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalizeBigDecimal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void rewardUnweighted() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).reward((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)2));
        this.assertDefaultJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    @Override
    @TestTemplate
    public void reward() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).reward((Score)SimpleScore.ONE, (entity, entity2, value) -> 2).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)4));
        this.assertDefaultJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void rewardLong() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void rewardBigDecimal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void impactPositiveUnweighted() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).impact((Score)SimpleScore.ONE).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)2));
        this.assertDefaultJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    @Override
    @TestTemplate
    public void impactPositive() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).impact((Score)SimpleScore.ONE, (entity, entity2, value) -> 2).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)4));
        this.assertDefaultJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void impactPositiveLong() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void impactPositiveBigDecimal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void impactNegative() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).impact((Score)SimpleScore.ONE, (entity, entity2, value) -> -2).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)-4));
        this.assertDefaultJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void impactNegativeLong() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void impactNegativeBigDecimal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void penalizeUnweightedCustomJustifications() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).penalize((Score)SimpleScore.ONE).justifyWith((a, b, c, score) -> new AbstractConstraintStreamTest.TestConstraintJustification<SimpleScore>((SimpleScore)score, a, b, c)).indictWith(Set::of).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)-2));
        this.assertCustomJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    private <Score_ extends Score<Score_>, Solution_, Entity_, Value_> void assertCustomJustifications(InnerScoreDirector<Solution_, Score_> scoreDirector, List<Entity_> entityList, List<Value_> valueList) {
        if (!this.implSupport.isConstreamMatchEnabled()) {
            return;
        }
        Assertions.assertThat((Map)scoreDirector.getIndictmentMap()).containsOnlyKeys(new Object[]{entityList.get(0), entityList.get(1), entityList.get(5), entityList.get(6), valueList.get(0), valueList.get(1)});
        String constraintFqn = ConstraintMatchTotal.composeConstraintId((String)scoreDirector.getSolutionDescriptor().getSolutionClass().getPackageName(), (String)"testConstraintName");
        Map constraintMatchTotalMap = scoreDirector.getConstraintMatchTotalMap();
        Assertions.assertThat((Map)constraintMatchTotalMap).containsOnlyKeys((Object[])new String[]{constraintFqn});
        ConstraintMatchTotal constraintMatchTotal = (ConstraintMatchTotal)constraintMatchTotalMap.get(constraintFqn);
        Assertions.assertThat((Collection)constraintMatchTotal.getConstraintMatchSet()).hasSize(2);
        ArrayList constraintMatchList = new ArrayList(constraintMatchTotal.getConstraintMatchSet());
        for (int i = 0; i < 2; ++i) {
            ConstraintMatch constraintMatch = (ConstraintMatch)constraintMatchList.get(i);
            SoftAssertions.assertSoftly(softly -> {
                ConstraintJustification justification = constraintMatch.getJustification();
                softly.assertThat((Object)justification).isInstanceOf(AbstractConstraintStreamTest.TestConstraintJustification.class);
                AbstractConstraintStreamTest.TestConstraintJustification castJustification = (AbstractConstraintStreamTest.TestConstraintJustification)justification;
                softly.assertThat(castJustification.getFacts()).hasSize(3);
                softly.assertThat(constraintMatch.getIndictedObjectList()).hasSize(3);
            });
        }
    }

    @Override
    @TestTemplate
    public void penalizeCustomJustifications() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).penalize((Score)SimpleScore.ONE, (entity, entity2, value) -> 2).justifyWith((a, b, c, score) -> new AbstractConstraintStreamTest.TestConstraintJustification<SimpleScore>((SimpleScore)score, a, b, c)).indictWith(Set::of).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)-4));
        this.assertCustomJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalizeLongCustomJustifications() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalizeBigDecimalCustomJustifications() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void rewardUnweightedCustomJustifications() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).reward((Score)SimpleScore.ONE).justifyWith((a, b, c, score) -> new AbstractConstraintStreamTest.TestConstraintJustification<SimpleScore>((SimpleScore)score, a, b, c)).indictWith(Set::of).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)2));
        this.assertCustomJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    @Override
    @TestTemplate
    public void rewardCustomJustifications() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).reward((Score)SimpleScore.ONE, (entity, entity2, value) -> 2).justifyWith((a, b, c, score) -> new AbstractConstraintStreamTest.TestConstraintJustification<SimpleScore>((SimpleScore)score, a, b, c)).indictWith(Set::of).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)4));
        this.assertCustomJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void rewardLongCustomJustifications() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void rewardBigDecimalCustomJustifications() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void impactPositiveUnweightedCustomJustifications() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).impact((Score)SimpleScore.ONE).justifyWith((a, b, c, score) -> new AbstractConstraintStreamTest.TestConstraintJustification<SimpleScore>((SimpleScore)score, a, b, c)).indictWith(Set::of).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)2));
        this.assertCustomJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    @Override
    @TestTemplate
    public void impactPositiveCustomJustifications() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).impact((Score)SimpleScore.ONE, (entity, entity2, value) -> 2).justifyWith((a, b, c, score) -> new AbstractConstraintStreamTest.TestConstraintJustification<SimpleScore>((SimpleScore)score, a, b, c)).indictWith(Set::of).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)4));
        this.assertCustomJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void impactPositiveLongCustomJustifications() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void impactPositiveBigDecimalCustomJustifications() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void impactNegativeCustomJustifications() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getValue)).join(TestdataLavishValue.class, Joiners.equal((entity, entity2) -> entity.getValue(), Function.identity())).impact((Score)SimpleScore.ONE, (entity, entity2, value) -> -2).justifyWith((a, b, c, score) -> new AbstractConstraintStreamTest.TestConstraintJustification<SimpleScore>((SimpleScore)score, a, b, c)).indictWith(Set::of).asConstraint("testConstraintName"));
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((Comparable)((SimpleScore)scoreDirector.calculateScore())).isEqualTo((Object)SimpleScore.of((int)-4));
        this.assertCustomJustifications(scoreDirector, solution.getEntityList(), solution.getValueList());
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void impactNegativeLongCustomJustifications() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void impactNegativeBigDecimalCustomJustifications() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

