/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.BendableBigDecimalScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataBendableBigDecimalScoreSolution;

class BendableBigDecimalScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataBendableBigDecimalScoreSolution, BendableBigDecimalScore> {
    BendableBigDecimalScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        BendableBigDecimalScoreInliner scoreInliner = new BendableBigDecimalScoreInliner(true, 1, 2);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Test
    void impactHard() {
        BendableBigDecimalScoreInliner scoreInliner = new BendableBigDecimalScoreInliner(true, 1, 2);
        BendableBigDecimalScore constraintWeight = this.buildScore(90L, 0L, 0L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(BigDecimal.ONE, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(90L, 0L, 0L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(BigDecimal.valueOf(2L), JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(270L, 0L, 0L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(90L, 0L, 0L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Test
    void impactSoft1() {
        BendableBigDecimalScoreInliner scoreInliner = new BendableBigDecimalScoreInliner(true, 1, 2);
        BendableBigDecimalScore constraintWeight = this.buildScore(0L, 90L, 0L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(BigDecimal.ONE, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 90L, 0L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(BigDecimal.valueOf(2L), JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 270L, 0L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 90L, 0L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Test
    void impactSoft2() {
        BendableBigDecimalScoreInliner scoreInliner = new BendableBigDecimalScoreInliner(true, 1, 2);
        BendableBigDecimalScore constraintWeight = this.buildScore(0L, 0L, 90L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(BigDecimal.ONE, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 90L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(BigDecimal.valueOf(2L), JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 270L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 90L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Test
    void impactAll() {
        BendableBigDecimalScoreInliner scoreInliner = new BendableBigDecimalScoreInliner(true, 1, 2);
        BendableBigDecimalScore constraintWeight = this.buildScore(10L, 100L, 1000L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(BigDecimal.TEN, JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(100L, 1000L, 10000L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(BigDecimal.valueOf(20L), JustificationsSupplier.empty());
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(300L, 3000L, 30000L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(100L, 1000L, 10000L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Override
    protected SolutionDescriptor<TestdataBendableBigDecimalScoreSolution> buildSolutionDescriptor() {
        return TestdataBendableBigDecimalScoreSolution.buildSolutionDescriptor();
    }

    private BendableBigDecimalScore buildScore(long hard, long soft1, long soft2) {
        return BendableBigDecimalScore.of((BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(hard)}, (BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(soft1), BigDecimal.valueOf(soft2)});
    }
}

