/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.drools.DroolsConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.drools.DroolsConstraintStreamScoreDirectorFactoryService;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

class ScoreDirectorFactoryFactoryTest {
    ScoreDirectorFactoryFactoryTest() {
    }

    @Test
    void constraintStreamsDroolsWithAlphaNetworkCompilationEnabled() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withConstraintProviderClass(TestdataConstraintProvider.class).withConstraintStreamImplType(ConstraintStreamImplType.DROOLS).withDroolsAlphaNetworkCompilationEnabled(true);
        InnerScoreDirectorFactory uncastScoreDirectorFactory = (InnerScoreDirectorFactory)new DroolsConstraintStreamScoreDirectorFactoryService().buildScoreDirectorFactory(null, TestdataSolution.buildSolutionDescriptor(), config).get();
        Assertions.assertThat((Object)uncastScoreDirectorFactory).isInstanceOf(DroolsConstraintStreamScoreDirectorFactory.class);
        DroolsConstraintStreamScoreDirectorFactory scoreDirectorFactory = (DroolsConstraintStreamScoreDirectorFactory)uncastScoreDirectorFactory;
        Assertions.assertThat((boolean)scoreDirectorFactory.isDroolsAlphaNetworkCompilationEnabled()).isTrue();
    }

    @Test
    void constraintStreamsDroolsWithAlphaNetworkCompilationDisabled() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withConstraintProviderClass(TestdataConstraintProvider.class).withConstraintStreamImplType(ConstraintStreamImplType.DROOLS).withDroolsAlphaNetworkCompilationEnabled(false);
        InnerScoreDirectorFactory uncastScoreDirectorFactory = (InnerScoreDirectorFactory)new DroolsConstraintStreamScoreDirectorFactoryService().buildScoreDirectorFactory(null, TestdataSolution.buildSolutionDescriptor(), config).get();
        Assertions.assertThat((Object)uncastScoreDirectorFactory).isInstanceOf(DroolsConstraintStreamScoreDirectorFactory.class);
        DroolsConstraintStreamScoreDirectorFactory scoreDirectorFactory = (DroolsConstraintStreamScoreDirectorFactory)uncastScoreDirectorFactory;
        Assertions.assertThat((boolean)scoreDirectorFactory.isDroolsAlphaNetworkCompilationEnabled()).isFalse();
    }

    public static class TestdataConstraintProvider
    implements ConstraintProvider {
        public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
            return new Constraint[0];
        }
    }
}

