/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.optaplanner.constraint.streams.common.AbstractAdvancedGroupByConstraintStreamTest;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamTest;
import org.optaplanner.constraint.streams.common.ConstraintStreamImplSupport;
import org.optaplanner.constraint.streams.drools.DroolsConstraintStreamImplSupport;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntity;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntityGroup;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishSolution;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;
import org.optaplanner.core.impl.util.Pair;

final class DroolsAdvancedGroupByConstraintStreamTest
extends AbstractAdvancedGroupByConstraintStreamTest {
    public DroolsAdvancedGroupByConstraintStreamTest(boolean constraintMatchEnabled) {
        super((ConstraintStreamImplSupport)new DroolsConstraintStreamImplSupport(constraintMatchEnabled));
    }

    @TestTemplate
    void collectedDowngradedAndFiltered() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntity entity = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(e -> e.getCode().substring(0, 1), ConstraintCollectors.count()).groupBy(Pair::of).filter(pair -> !((String)pair.getKey()).equals("G")).penalize("testConstraintName", (Score)SimpleScore.ONE, Pair::getValue));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatch((Object[])new Object[]{Pair.of((Object)"M", (Object)1)})});
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @TestTemplate
    void collectedAndFiltered() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(ConstraintCollectors.count()).filter(count -> count == 10).penalize("testConstraintName", (Score)SimpleScore.ONE, i -> i));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-10, (Object[])new Object[]{10})});
        Stream.of(entity1, entity2).forEach(entity -> {
            scoreDirector.beforeEntityRemoved(entity);
            solution.getEntityList().remove(entity);
            scoreDirector.afterEntityRemoved(entity);
        });
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @TestTemplate
    void collectedFilteredRecollected() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)2);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(ConstraintCollectors.toSet()).groupBy(ConstraintCollectors.sum(Set::size)).penalize("testConstraintName", (Score)SimpleScore.ONE, count -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-2, (Object[])new Object[]{2})});
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{1})});
    }

    @TestTemplate
    void uniGroupByRecollected() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)2);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup).groupBy(ConstraintCollectors.toSet()).penalize("testConstraintName", (Score)SimpleScore.ONE, Set::size));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-2, (Object[])new Object[]{DroolsAdvancedGroupByConstraintStreamTest.asSet((Object[])new Object[]{entity1.getEntityGroup(), entity2.getEntityGroup()})})});
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{DroolsAdvancedGroupByConstraintStreamTest.asSet((Object[])new Object[]{entity2.getEntityGroup()})})});
    }

    @TestTemplate
    void biGroupByRecollected() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)3, (int)2, (int)5);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).groupBy((a, b) -> a.getEntityGroup(), ConstraintCollectors.countBi()).groupBy(ConstraintCollectors.toMap((g, c) -> g, (g, c) -> c, Integer::sum)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{PlannerTestUtils.asMap((Object)solution.getFirstEntityGroup(), (Object)3, (Object)((TestdataLavishEntityGroup)solution.getEntityGroupList().get(1)), (Object)1)})});
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{PlannerTestUtils.asMap((Object)solution.getFirstEntityGroup(), (Object)1, (Object)((TestdataLavishEntityGroup)solution.getEntityGroupList().get(1)), (Object)1)})});
    }

    @TestTemplate
    void triGroupByRecollected() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)3, (int)2, (int)6);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c) -> !Objects.equals(a, c) && !Objects.equals(b, c))).groupBy((a, b, c) -> a.getEntityGroup(), ConstraintCollectors.countTri()).groupBy(ConstraintCollectors.toMap((g, c) -> g, (g, c) -> c, Integer::sum)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{PlannerTestUtils.asMap((Object)solution.getFirstEntityGroup(), (Object)3, (Object)((TestdataLavishEntityGroup)solution.getEntityGroupList().get(1)), (Object)3)})});
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{PlannerTestUtils.asMap((Object)((TestdataLavishEntityGroup)solution.getEntityGroupList().get(1)), (Object)3)})});
    }

    @TestTemplate
    void quadGroupByRecollected() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)3, (int)2, (int)8);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c) -> !Objects.equals(a, c) && !Objects.equals(b, c))).join(TestdataLavishEntity.class, Joiners.equal((a, b, c) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c, d) -> !Objects.equals(a, d) && !Objects.equals(b, d) && !Objects.equals(c, d))).groupBy((a, b, c, d) -> a.getEntityGroup(), ConstraintCollectors.countQuad()).groupBy(ConstraintCollectors.toMap((g, c) -> g, (g, c) -> c, Integer::sum)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{PlannerTestUtils.asMap((Object)solution.getFirstEntityGroup(), (Object)12, (Object)((TestdataLavishEntityGroup)solution.getEntityGroupList().get(1)), (Object)12)})});
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{PlannerTestUtils.asMap((Object)((TestdataLavishEntityGroup)solution.getEntityGroupList().get(1)), (Object)12)})});
    }

    @TestTemplate
    void biGroupByRegrouped() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)4);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).groupBy((a, b) -> a.getEntityGroup()).groupBy(Function.identity(), ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE, (group, count) -> count));
        TestdataLavishEntity entity = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity.getEntityGroup(), 1}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup(), 1})});
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup(), 1})});
    }

    @TestTemplate
    void triGroupByRegrouped() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)6);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c) -> !Objects.equals(a, c) && !Objects.equals(b, c))).groupBy((a, b, c) -> a.getEntityGroup()).groupBy(Function.identity(), ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE, (group, count) -> count));
        TestdataLavishEntity entity = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity.getEntityGroup(), 1}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup(), 1})});
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup(), 1})});
    }

    @TestTemplate
    void quadGroupByRegrouped() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)8);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c) -> !Objects.equals(a, c) && !Objects.equals(b, c))).join(TestdataLavishEntity.class, Joiners.equal((a, b, c) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c, d) -> !Objects.equals(a, d) && !Objects.equals(b, d) && !Objects.equals(c, d))).groupBy((a, b, c, d) -> a.getEntityGroup()).groupBy(Function.identity(), ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE, (group, count) -> count));
        TestdataLavishEntity entity = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity.getEntityGroup(), 1}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup(), 1})});
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup(), 1})});
    }

    @TestTemplate
    void biGroupByRegroupedDouble() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)4);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).groupBy((a, b) -> a.getEntityGroup()).groupBy(Function.identity(), ConstraintCollectors.count()).groupBy((group, count) -> group.toString(), ConstraintCollectors.countBi()).penalize("testConstraintName", (Score)SimpleScore.ONE, (groupName, count) -> count));
        TestdataLavishEntity entity = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity.getEntityGroup().toString(), 1}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup().toString(), 1})});
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup().toString(), 1})});
    }

    @TestTemplate
    void triGroupByRegroupedDouble() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)6);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c) -> !Objects.equals(a, c) && !Objects.equals(b, c))).groupBy((a, b, c) -> a.getEntityGroup()).groupBy(Function.identity(), ConstraintCollectors.count()).groupBy((group, count) -> group.toString(), ConstraintCollectors.countBi()).penalize("testConstraintName", (Score)SimpleScore.ONE, (groupName, count) -> count));
        TestdataLavishEntity entity = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity.getEntityGroup().toString(), 1}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup().toString(), 1})});
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup().toString(), 1})});
    }

    @TestTemplate
    void quadGroupByRegroupedDouble() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)8);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).join(TestdataLavishEntity.class, Joiners.equal((a, b) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c) -> !Objects.equals(a, c) && !Objects.equals(b, c))).join(TestdataLavishEntity.class, Joiners.equal((a, b, c) -> a.getEntityGroup(), TestdataLavishEntity::getEntityGroup), Joiners.filtering((a, b, c, d) -> !Objects.equals(a, d) && !Objects.equals(b, d) && !Objects.equals(c, d))).groupBy((a, b, c, d) -> a.getEntityGroup()).groupBy(Function.identity(), ConstraintCollectors.count()).groupBy((group, count) -> group.toString(), ConstraintCollectors.countBi()).penalize("testConstraintName", (Score)SimpleScore.ONE, (groupName, count) -> count));
        TestdataLavishEntity entity = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity.getEntityGroup().toString(), 1}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup().toString(), 1})});
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity2.getEntityGroup().toString(), 1})});
    }

    @TestTemplate
    void existsAfterGroupBy() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, ConstraintCollectors.count()).ifExists(TestdataLavishEntityGroup.class, Joiners.equal((groupA, count) -> groupA, Function.identity())).penalize("testConstraintName", (Score)SimpleScore.ONE, (groupA, count) -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-2, (Object[])new Object[]{solution.getFirstEntityGroup(), 2}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-2, (Object[])new Object[]{entityGroup1, 2})});
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup1);
        solution.getEntityGroupList().remove(entityGroup1);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-2, (Object[])new Object[]{solution.getFirstEntityGroup(), 2})});
    }

    @TestTemplate
    void groupByAfterExists() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifExists(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).groupBy(TestdataLavishEntity::getEntityGroup, ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE, (groupA, count) -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-2, (Object[])new Object[]{solution.getFirstEntityGroup(), 2}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-2, (Object[])new Object[]{entityGroup1, 2})});
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup1);
        solution.getEntityGroupList().remove(entityGroup1);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-2, (Object[])new Object[]{solution.getFirstEntityGroup(), 2})});
    }

    @TestTemplate
    void groupByAfterExistsBi() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifExists(TestdataLavishEntityGroup.class, Joiners.equal((e1, e2) -> e1.getEntityGroup(), Function.identity())).groupBy((e1, e2) -> e1.getEntityGroup(), ConstraintCollectors.countBi()).penalize("testConstraintName", (Score)SimpleScore.ONE, (groupA, count) -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-3, (Object[])new Object[]{solution.getFirstEntityGroup(), 3}), DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-3, (Object[])new Object[]{entityGroup1, 3})});
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup1);
        solution.getEntityGroupList().remove(entityGroup1);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-3, (Object[])new Object[]{solution.getFirstEntityGroup(), 3})});
    }

    @TestTemplate
    void filteredFromUniquePair() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup), Joiners.filtering((e1, e2) -> !e1.getCode().contains("My"))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[]{DroolsAdvancedGroupByConstraintStreamTest.assertMatchWithScore((int)-1, (Object[])new Object[]{entity3, solution.getFirstEntity()})});
        scoreDirector.beforeProblemFactRemoved((Object)entity3);
        solution.getEntityList().remove(entity3);
        scoreDirector.afterProblemFactRemoved((Object)entity3);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @TestTemplate
    void groupByThenJoinThenGroupBy() {
        Assertions.assertThatCode(() -> this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, TestdataLavishEntity::getValue).join(TestdataLavishEntity.class).groupBy((group, value, entity) -> group, (group, value, entity) -> entity, ConstraintCollectors.sum((group, count, entity) -> 1)).penalize("testConstraintName", (Score)SimpleScore.ONE))).doesNotThrowAnyException();
    }
}

