/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.drools.model.BetaIndex4;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function4;
import org.drools.model.functions.Predicate5;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.constraint.streams.common.penta.DefaultPentaJoiner;
import org.optaplanner.constraint.streams.common.penta.FilteringPentaJoiner;
import org.optaplanner.constraint.streams.drools.DroolsVariableFactory;
import org.optaplanner.constraint.streams.drools.common.AbstractLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.BiLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.BiTuple;
import org.optaplanner.constraint.streams.drools.common.DetachedPatternVariable;
import org.optaplanner.constraint.streams.drools.common.DirectPatternVariable;
import org.optaplanner.constraint.streams.drools.common.IndirectPatternVariable;
import org.optaplanner.constraint.streams.drools.common.PatternVariable;
import org.optaplanner.constraint.streams.drools.common.QuadAccumulator;
import org.optaplanner.constraint.streams.drools.common.QuadRuleContext;
import org.optaplanner.constraint.streams.drools.common.QuadTuple;
import org.optaplanner.constraint.streams.drools.common.RuleBuilder;
import org.optaplanner.constraint.streams.drools.common.TriLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.TriTuple;
import org.optaplanner.constraint.streams.drools.common.UniLeftHandSide;
import org.optaplanner.core.api.function.PentaPredicate;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.JoinerType;

public final class QuadLeftHandSide<A, B, C, D>
extends AbstractLeftHandSide {
    private final PatternVariable<A, ?, ?> patternVariableA;
    private final PatternVariable<B, ?, ?> patternVariableB;
    private final PatternVariable<C, ?, ?> patternVariableC;
    private final PatternVariable<D, ?, ?> patternVariableD;
    private final QuadRuleContext<A, B, C, D> ruleContext;

    QuadLeftHandSide(Variable<A> variableA, Variable<B> variableB, Variable<C> variableC, PatternVariable<D, ?, ?> patternVariableD, DroolsVariableFactory variableFactory) {
        this(new DetachedPatternVariable(variableA), new DetachedPatternVariable(variableB), new DetachedPatternVariable(variableC), patternVariableD, variableFactory);
    }

    QuadLeftHandSide(PatternVariable<A, ?, ?> patternVariableA, PatternVariable<B, ?, ?> patternVariableB, PatternVariable<C, ?, ?> patternVariableC, PatternVariable<D, ?, ?> patternVariableD, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariableA = Objects.requireNonNull(patternVariableA);
        this.patternVariableB = Objects.requireNonNull(patternVariableB);
        this.patternVariableC = Objects.requireNonNull(patternVariableC);
        this.patternVariableD = Objects.requireNonNull(patternVariableD);
        this.ruleContext = this.buildRuleContext();
    }

    private QuadRuleContext<A, B, C, D> buildRuleContext() {
        ViewItem[] viewItems = (ViewItem[])Stream.of(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD).flatMap(variable -> variable.build().stream()).toArray(ViewItem[]::new);
        return new QuadRuleContext<A, B, C, D>(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), viewItems);
    }

    public QuadLeftHandSide<A, B, C, D> andFilter(QuadPredicate<A, B, C, D> predicate) {
        return new QuadLeftHandSide<A, B, C, D>(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD.filter(predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable()), this.variableFactory);
    }

    private <E> QuadLeftHandSide<A, B, C, D> applyJoiners(Class<E> otherFactType, Predicate<E> nullityFilter, DefaultPentaJoiner<A, B, C, D, E> joiner, PentaPredicate<A, B, C, D, E> predicate, boolean shouldExist) {
        Variable toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (nullityFilter != null) {
            existencePattern = existencePattern.expr("Exclude nulls using " + nullityFilter, nullityFilter::test);
        }
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        int joinerCount = joiner.getJoinerCount();
        for (int mappingIndex = 0; mappingIndex < joinerCount; ++mappingIndex) {
            JoinerType joinerType = joiner.getJoinerType(mappingIndex);
            QuadFunction leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate5 & Serializable joinPredicate = (Predicate5 & Serializable)(e, a, b, c, d) -> joinerType.matches(leftMapping.apply(a, b, c, d), rightMapping.apply(e));
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), (Predicate5)joinPredicate, this.createBetaIndex(joiner, mappingIndex));
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <E> BetaIndex4<E, A, B, C, D, ?> createBetaIndex(DefaultPentaJoiner<A, B, C, D, E> joiner, int mappingIndex) {
        JoinerType joinerType = joiner.getJoinerType(mappingIndex);
        QuadFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        if (joinerType == JoinerType.EQUAL) {
            return PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)QuadLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, (arg_0, arg_1, arg_2, arg_3) -> ((QuadFunction)leftMapping).apply(arg_0, arg_1, arg_2, arg_3), Object.class);
        }
        JoinerType reversedJoinerType = joinerType.flip();
        return PatternDSL.betaIndexedBy(Comparable.class, (Index.ConstraintType)QuadLeftHandSide.getConstraintType(reversedJoinerType), (int)mappingIndex, (Function1 & Serializable)e -> (Comparable)rightMapping.apply(e), (arg_0, arg_1, arg_2, arg_3) -> ((QuadFunction)leftMapping).apply(arg_0, arg_1, arg_2, arg_3), Comparable.class);
    }

    private <E> QuadLeftHandSide<A, B, C, D> applyFilters(PatternDSL.PatternDef<E> existencePattern, PentaPredicate<A, B, C, D, E> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), (Predicate5 & Serializable)(e, a, b, c, d) -> predicate.test(a, b, c, d, e));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new QuadLeftHandSide<A, B, C, D>(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD.addDependentExpression((ViewItem<?>)existenceExpression), this.variableFactory);
    }

    private <E> QuadLeftHandSide<A, B, C, D> existsOrNot(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners, Predicate<E> nullityFilter, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        FilteringPentaJoiner finalJoiner = null;
        PentaPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            FilteringPentaJoiner castJoiner;
            boolean hasAFilter;
            PentaJoiner<A, B, C, D, E> joiner = joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof FilteringPentaJoiner) {
                if (!hasAFilter) {
                    indexOfFirstFilter = i;
                }
                castJoiner = (FilteringPentaJoiner)joiner;
                finalFilter = finalFilter == null ? castJoiner.getFilter() : finalFilter.and(castJoiner.getFilter());
                continue;
            }
            if (hasAFilter) {
                throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
            }
            castJoiner = (DefaultPentaJoiner)joiner;
            finalJoiner = finalJoiner == null ? castJoiner : finalJoiner.and((PentaJoiner)castJoiner);
        }
        return this.applyJoiners(dClass, nullityFilter, (DefaultPentaJoiner<A, B, C, D, E>)finalJoiner, (PentaPredicate<A, B, C, D, E>)finalFilter, shouldExist);
    }

    public <E> QuadLeftHandSide<A, B, C, D> andExists(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners, Predicate<E> nullityFilter) {
        return this.existsOrNot(dClass, joiners, nullityFilter, true);
    }

    public <E> QuadLeftHandSide<A, B, C, D> andNotExists(Class<E> dClass, PentaJoiner<A, B, C, D, E>[] joiners, Predicate<E> nullityFilter) {
        return this.existsOrNot(dClass, joiners, nullityFilter, false);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collector) {
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(this.createAccumulateFunction(collector, accumulateOutput));
        return new UniLeftHandSide(accumulateOutput, Collections.singletonList(outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB));
        return new BiLeftHandSide(accumulateOutputA, new DirectPatternVariable(accumulateOutputB, outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC));
        return new TriLeftHandSide(accumulateOutputA, accumulateOutputB, new DirectPatternVariable(accumulateOutputC, outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadConstraintCollector<A, B, C, D, ?, NewA> collectorA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        return new QuadLeftHandSide(accumulateOutputA, accumulateOutputB, accumulateOutputC, new DirectPatternVariable(accumulateOutputD, outerAccumulatePattern), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(QuadConstraintCollector<A, B, C, D, ?, Out> collector, Variable<Out> out) {
        Variable variableA = this.patternVariableA.getPrimaryVariable();
        Variable variableB = this.patternVariableB.getPrimaryVariable();
        Variable variableC = this.patternVariableC.getPrimaryVariable();
        Variable variableD = this.patternVariableD.getPrimaryVariable();
        return new AccumulateFunction(null, () -> new QuadAccumulator(variableA, variableB, variableC, variableD, collector)).with(new Variable[]{variableA, variableB, variableC, variableD}).as(out);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMapping) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (arg_0, arg_1, arg_2, arg_3) -> keyMapping.apply(arg_0, arg_1, arg_2, arg_3), new AccumulateFunction[0]);
        return new UniLeftHandSide(groupKey, Collections.singletonList(groupByPattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (arg_0, arg_1, arg_2, arg_3) -> keyMappingA.apply(arg_0, arg_1, arg_2, arg_3), this.createAccumulateFunction(collectorB, accumulateOutput));
        return new BiLeftHandSide(groupKey, new DirectPatternVariable(accumulateOutput, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (arg_0, arg_1, arg_2, arg_3) -> keyMappingA.apply(arg_0, arg_1, arg_2, arg_3), this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC));
        return new TriLeftHandSide(groupKey, accumulateOutputB, new DirectPatternVariable(accumulateOutputC, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadConstraintCollector<A, B, C, D, ?, NewB> collectorB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (arg_0, arg_1, arg_2, arg_3) -> keyMappingA.apply(arg_0, arg_1, arg_2, arg_3), this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        return new QuadLeftHandSide(groupKey, accumulateOutputB, accumulateOutputC, new DirectPatternVariable(accumulateOutputD, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        IndirectPatternVariable bPatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        return new BiLeftHandSide(newA, bPatternVar, this.variableFactory);
    }

    private <NewA, NewB> Function4<A, B, C, D, BiTuple<NewA, NewB>> createCompositeBiGroupKey(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB) {
        return (Function4 & Serializable)(a, b, c, d) -> new BiTuple<Object, Object>(keyMappingA.apply(a, b, c, d), keyMappingB.apply(a, b, c, d));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), this.createAccumulateFunction(collectorC, accumulateOutput));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable cPatternVar = QuadLeftHandSide.decomposeWithAccumulate(groupKey, groupByPattern, newA, newB, accumulateOutput);
        return new TriLeftHandSide(newA, newB, cPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadConstraintCollector<A, B, C, D, ?, NewC> collectorC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeBiGroupKey(keyMappingA, keyMappingB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable dPatternVar = QuadLeftHandSide.decomposeWithAccumulate(groupKey, groupByPattern, newA, newB, accumulateOutputD);
        return new QuadLeftHandSide(newA, newB, accumulateOutputC, dPatternVar, this.variableFactory);
    }

    private <NewA, NewB, NewC> Function4<A, B, C, D, TriTuple<NewA, NewB, NewC>> createCompositeTriGroupKey(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC) {
        return (Function4 & Serializable)(a, b, c, d) -> new TriTuple<Object, Object, Object>(keyMappingA.apply(a, b, c, d), keyMappingB.apply(a, b, c, d), keyMappingC.apply(a, b, c, d));
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC) {
        Variable groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeTriGroupKey(keyMappingA, keyMappingB, keyMappingC), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        IndirectPatternVariable cPatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC);
        return new TriLeftHandSide(newA, newB, cPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC, QuadConstraintCollector<A, B, C, D, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeTriGroupKey(keyMappingA, keyMappingB, keyMappingC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        DirectPatternVariable dPatternVar = QuadLeftHandSide.decomposeWithAccumulate(groupKey, groupByPattern, newA, newB, newC, accumulateOutputD);
        return new QuadLeftHandSide(newA, newB, newC, dPatternVar, this.variableFactory);
    }

    private <NewA, NewB, NewC, NewD> Function4<A, B, C, D, QuadTuple<NewA, NewB, NewC, NewD>> createCompositeQuadGroupKey(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC, QuadFunction<A, B, C, D, NewD> keyMappingD) {
        return (Function4 & Serializable)(a, b, c, d) -> new QuadTuple<Object, Object, Object, Object>(keyMappingA.apply(a, b, c, d), keyMappingB.apply(a, b, c, d), keyMappingC.apply(a, b, c, d), keyMappingD.apply(a, b, c, d));
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(QuadFunction<A, B, C, D, NewA> keyMappingA, QuadFunction<A, B, C, D, NewB> keyMappingB, QuadFunction<A, B, C, D, NewC> keyMappingC, QuadFunction<A, B, C, D, NewD> keyMappingD) {
        Variable groupKey = this.variableFactory.createVariable(QuadTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, this.createCompositeQuadGroupKey(keyMappingA, keyMappingB, keyMappingC, keyMappingD), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        Variable newD = this.variableFactory.createVariable("newD");
        IndirectPatternVariable dPatternVar = QuadLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC, newD);
        return new QuadLeftHandSide(newA, newB, newC, dPatternVar, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andMap(QuadFunction<A, B, C, D, NewA> mapping) {
        Variable<NewA> newA = this.variableFactory.createVariable("mapped", this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), this.patternVariableD.getPrimaryVariable(), mapping);
        List<ViewItem<?>> allPrerequisites = QuadLeftHandSide.mergeViewItems(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD);
        DirectPatternVariable<NewA> newPatternVariableA = new DirectPatternVariable<NewA>(newA, allPrerequisites);
        return new UniLeftHandSide(newPatternVariableA, this.variableFactory);
    }

    public <NewD> QuadLeftHandSide<A, B, C, NewD> andFlattenLast(Function<D, Iterable<NewD>> mapping) {
        Variable<D> source = this.patternVariableD.getPrimaryVariable();
        Variable<NewD> newD = this.variableFactory.createFlattenedVariable("flattened", source, mapping);
        List<ViewItem<?>> allPrerequisites = QuadLeftHandSide.mergeViewItems(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD);
        DirectPatternVariable<NewD> newPatternVariableD = new DirectPatternVariable<NewD>(newD, allPrerequisites);
        return new QuadLeftHandSide<A, B, C, D>(this.patternVariableA.getPrimaryVariable(), this.patternVariableB.getPrimaryVariable(), this.patternVariableC.getPrimaryVariable(), newPatternVariableD, this.variableFactory);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate() {
        return this.ruleContext.newRuleBuilder();
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToIntQuadFunction<A, B, C, D> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToLongQuadFunction<A, B, C, D> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(QuadFunction<A, B, C, D, BigDecimal> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    private ViewItem<?> buildAccumulate(AccumulateFunction ... accFunctions) {
        ViewItem<?> innerAccumulatePattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD);
        return QuadLeftHandSide.buildAccumulate(innerAccumulatePattern, accFunctions);
    }

    private <GroupKey_> ViewItem<?> buildGroupBy(Variable<GroupKey_> groupKey, Function4<A, B, C, D, GroupKey_> groupKeyExtractor, AccumulateFunction ... accFunctions) {
        Variable<A> inputA = this.patternVariableA.getPrimaryVariable();
        Variable<B> inputB = this.patternVariableB.getPrimaryVariable();
        Variable<C> inputC = this.patternVariableC.getPrimaryVariable();
        Variable<D> inputD = this.patternVariableD.getPrimaryVariable();
        ViewItem<?> innerGroupByPattern = QuadLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariableA, this.patternVariableB, this.patternVariableC, this.patternVariableD);
        return DSL.groupBy(innerGroupByPattern, inputA, inputB, inputC, inputD, groupKey, groupKeyExtractor, (AccumulateFunction[])accFunctions);
    }
}

