/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Declaration;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.model.Variable;
import org.kie.api.runtime.rule.FactHandle;
import org.optaplanner.constraint.streams.drools.common.AbstractAccumulator;
import org.optaplanner.constraint.streams.drools.common.ValueExtractor;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;

final class UniAccumulator<A, ResultContainer_, Result_>
extends AbstractAccumulator<ResultContainer_, Result_> {
    private final String varA;
    private final BiFunction<ResultContainer_, A, Runnable> accumulator;
    private Declaration declaration;
    private UnaryOperator<BaseTuple> tupleExtractor;
    private boolean isSubnetwork;

    public UniAccumulator(Variable<A> varA, UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        super(collector.supplier(), collector.finisher());
        this.varA = varA.getName();
        this.accumulator = Objects.requireNonNull(collector.accumulator());
    }

    @Override
    protected Runnable accumulate(ResultContainer_ context, BaseTuple leftTuple, FactHandle handle, Declaration[] innerDeclarations) {
        FactHandle factHandle = this.getInternalFactHandle(leftTuple, handle);
        Object a = this.declaration.getValue(null, factHandle.getObject());
        return this.accumulator.apply(context, a);
    }

    private FactHandle getInternalFactHandle(BaseTuple leftTuple, FactHandle handle) {
        if (this.tupleExtractor == null) {
            if (this.isSubnetwork) {
                return leftTuple.getFactHandle();
            }
            return handle;
        }
        return ((BaseTuple)this.tupleExtractor.apply(leftTuple)).getFactHandle();
    }

    @Override
    protected void initialize(BaseTuple leftTuple, Declaration[] innerDeclarations) {
        for (Declaration declaration : innerDeclarations) {
            if (!declaration.getBindingName().equals(this.varA)) continue;
            this.declaration = declaration;
            break;
        }
        this.isSubnetwork = leftTuple instanceof SubnetworkTuple;
        if (this.isSubnetwork) {
            this.tupleExtractor = ValueExtractor.getTupleExtractor(this.declaration, leftTuple);
        }
    }
}

