/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.io.Serializable;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.BetaIndex;
import org.drools.model.BetaIndex2;
import org.drools.model.BetaIndex3;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Function4;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.Predicate4;
import org.drools.model.view.ViewItem;
import org.optaplanner.constraint.streams.common.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.common.quad.DefaultQuadJoiner;
import org.optaplanner.constraint.streams.common.tri.DefaultTriJoiner;
import org.optaplanner.constraint.streams.drools.common.AbstractLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.PatternVariable;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.score.stream.JoinerType;

abstract class AbstractPatternVariable<A, PatternVar_, Child_ extends AbstractPatternVariable<A, PatternVar_, Child_>>
implements PatternVariable<A, PatternVar_, Child_> {
    private final Variable<A> primaryVariable;
    private final PatternDSL.PatternDef<PatternVar_> pattern;
    private final List<ViewItem<?>> prerequisiteExpressions;
    private final List<ViewItem<?>> dependentExpressions;

    protected AbstractPatternVariable(Variable<A> aVariable, PatternDSL.PatternDef<PatternVar_> pattern, List<ViewItem<?>> prerequisiteExpressions, List<ViewItem<?>> dependentExpressions) {
        this.primaryVariable = aVariable;
        this.pattern = pattern;
        this.prerequisiteExpressions = prerequisiteExpressions;
        this.dependentExpressions = dependentExpressions;
    }

    protected AbstractPatternVariable(AbstractPatternVariable<?, PatternVar_, ?> patternCreator, Variable<A> boundVariable) {
        this.primaryVariable = boundVariable;
        this.pattern = patternCreator.getPattern();
        this.prerequisiteExpressions = patternCreator.getPrerequisiteExpressions();
        this.dependentExpressions = patternCreator.getDependentExpressions();
    }

    protected AbstractPatternVariable(AbstractPatternVariable<A, PatternVar_, ?> patternCreator, ViewItem<?> dependentExpression) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.pattern = patternCreator.pattern;
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = Stream.concat(patternCreator.dependentExpressions.stream(), Stream.of(dependentExpression)).collect(Collectors.toList());
    }

    @Override
    public Variable<A> getPrimaryVariable() {
        return this.primaryVariable;
    }

    public PatternDSL.PatternDef<PatternVar_> getPattern() {
        return this.pattern;
    }

    @Override
    public List<ViewItem<?>> getPrerequisiteExpressions() {
        return this.prerequisiteExpressions;
    }

    @Override
    public List<ViewItem<?>> getDependentExpressions() {
        return this.dependentExpressions;
    }

    protected abstract A extract(PatternVar_ var1);

    @Override
    public final Child_ filter(Predicate<A> predicate) {
        this.pattern.expr("Filter using " + predicate, (Predicate1 & Serializable)a -> predicate.test(this.extract(a)));
        return (Child_)this;
    }

    @Override
    public final <LeftJoinVar_> Child_ filter(BiPredicate<LeftJoinVar_, A> predicate, Variable<LeftJoinVar_> leftJoinVariable) {
        this.pattern.expr("Filter using " + predicate, leftJoinVariable, (Predicate2 & Serializable)(a, leftJoinVar) -> predicate.test(leftJoinVar, this.extract(a)));
        return (Child_)this;
    }

    @Override
    public final <LeftJoinVarA_, LeftJoinVarB_> Child_ filter(TriPredicate<LeftJoinVarA_, LeftJoinVarB_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB) {
        this.pattern.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, (Predicate3 & Serializable)(a, leftJoinVarA, leftJoinVarB) -> predicate.test(leftJoinVarA, leftJoinVarB, this.extract(a)));
        return (Child_)this;
    }

    @Override
    public final <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> Child_ filter(QuadPredicate<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC) {
        this.pattern.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, (Predicate4 & Serializable)(a, leftJoinVarA, leftJoinVarB, leftJoinVarC) -> predicate.test(leftJoinVarA, leftJoinVarB, leftJoinVarC, this.extract(a)));
        return (Child_)this;
    }

    public final <LeftJoinVar_> Child_ filterForJoin(Variable<LeftJoinVar_> leftJoinVar, DefaultBiJoiner<LeftJoinVar_, A> joiner, JoinerType joinerType, int mappingIndex) {
        Function leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(leftMapping.apply(a), rightExtractor.apply(b));
        BetaIndex<PatternVar_, LeftJoinVar_, ?> index = this.createBetaIndex(joinerType, mappingIndex, leftMapping, rightExtractor);
        this.pattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVar, (Predicate2)predicate, index);
        return (Child_)this;
    }

    private <LeftJoinVar_> BetaIndex<PatternVar_, LeftJoinVar_, ?> createBetaIndex(JoinerType joinerType, int mappingIndex, Function<LeftJoinVar_, Object> leftMapping, Function1<PatternVar_, Object> rightExtractor) {
        if (joinerType == JoinerType.EQUAL) {
            return PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightExtractor, leftMapping::apply, Object.class);
        }
        JoinerType reversedJoinerType = joinerType.flip();
        return PatternDSL.betaIndexedBy(Comparable.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(reversedJoinerType), (int)mappingIndex, (Function1 & Serializable)c -> (Comparable)rightExtractor.apply(c), leftMapping::apply, Comparable.class);
    }

    public final <LeftJoinVarA_, LeftJoinVarB_> Child_ filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, DefaultTriJoiner<LeftJoinVarA_, LeftJoinVarB_, A> joiner, JoinerType joinerType, int mappingIndex) {
        BiFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate3 & Serializable predicate = (Predicate3 & Serializable)(c, a, b) -> joinerType.matches(leftMapping.apply(a, b), rightExtractor.apply(c));
        BetaIndex2<PatternVar_, LeftJoinVarA_, LeftJoinVarB_, ?> index = this.createBetaIndex(joinerType, mappingIndex, leftMapping, rightExtractor);
        this.pattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, (Predicate3)predicate, index);
        return (Child_)this;
    }

    private <LeftJoinVarA_, LeftJoinVarB_> BetaIndex2<PatternVar_, LeftJoinVarA_, LeftJoinVarB_, ?> createBetaIndex(JoinerType joinerType, int mappingIndex, BiFunction<LeftJoinVarA_, LeftJoinVarB_, Object> leftMapping, Function1<PatternVar_, Object> rightExtractor) {
        if (joinerType == JoinerType.EQUAL) {
            return PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightExtractor, leftMapping::apply, Object.class);
        }
        JoinerType reversedJoinerType = joinerType.flip();
        return PatternDSL.betaIndexedBy(Comparable.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(reversedJoinerType), (int)mappingIndex, (Function1 & Serializable)c -> (Comparable)rightExtractor.apply(c), leftMapping::apply, Comparable.class);
    }

    public final <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> Child_ filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, Variable<LeftJoinVarC_> leftJoinVarC, DefaultQuadJoiner<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> joiner, JoinerType joinerType, int mappingIndex) {
        TriFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate4 & Serializable predicate = (Predicate4 & Serializable)(d, a, b, c) -> joinerType.matches(leftMapping.apply(a, b, c), rightExtractor.apply(d));
        BetaIndex3<PatternVar_, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, ?> index = this.createBetaIndex(joinerType, mappingIndex, leftMapping, rightExtractor);
        this.pattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, leftJoinVarC, (Predicate4)predicate, index);
        return (Child_)this;
    }

    private <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> BetaIndex3<PatternVar_, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, ?> createBetaIndex(JoinerType joinerType, int mappingIndex, TriFunction<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, Object> leftMapping, Function1<PatternVar_, Object> rightExtractor) {
        if (joinerType == JoinerType.EQUAL) {
            return PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightExtractor, (arg_0, arg_1, arg_2) -> leftMapping.apply(arg_0, arg_1, arg_2), Object.class);
        }
        JoinerType reversedJoinerType = joinerType.flip();
        return PatternDSL.betaIndexedBy(Comparable.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(reversedJoinerType), (int)mappingIndex, (Function1 & Serializable)c -> (Comparable)rightExtractor.apply(c), (arg_0, arg_1, arg_2) -> leftMapping.apply(arg_0, arg_1, arg_2), Comparable.class);
    }

    @Override
    public final <BoundVar_> Child_ bind(Variable<BoundVar_> boundVariable, Function<A, BoundVar_> bindingFunction) {
        this.pattern.bind(boundVariable, (Function1 & Serializable)a -> bindingFunction.apply(this.extract(a)));
        return (Child_)this;
    }

    @Override
    public final <BoundVar_, LeftJoinVar_> Child_ bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVar_> leftJoinVariable, BiFunction<A, LeftJoinVar_, BoundVar_> bindingFunction) {
        this.pattern.bind(boundVariable, leftJoinVariable, (Function2 & Serializable)(a, leftJoinVar) -> bindingFunction.apply(this.extract(a), leftJoinVar));
        return (Child_)this;
    }

    @Override
    public final <BoundVar_, LeftJoinVarA_, LeftJoinVarB_> Child_ bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, TriFunction<A, LeftJoinVarA_, LeftJoinVarB_, BoundVar_> bindingFunction) {
        this.pattern.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, (Function3 & Serializable)(a, leftJoinVarA, leftJoinVarB) -> bindingFunction.apply(this.extract(a), leftJoinVarA, leftJoinVarB));
        return (Child_)this;
    }

    @Override
    public final <BoundVar_, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> Child_ bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC, QuadFunction<A, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, BoundVar_> bindingFunction) {
        this.pattern.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, (Function4 & Serializable)(a, leftJoinVarA, leftJoinVarB, leftJoinVarC) -> bindingFunction.apply(this.extract(a), leftJoinVarA, leftJoinVarB, leftJoinVarC));
        return (Child_)this;
    }

    @Override
    public final List<ViewItem<?>> build() {
        Stream prerequisites = this.prerequisiteExpressions.stream();
        Stream dependents = this.dependentExpressions.stream();
        return Stream.concat(Stream.concat(prerequisites, Stream.of(this.pattern)), dependents).collect(Collectors.toList());
    }
}

