/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.tri;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.drools.DroolsConstraintFactory;
import org.optaplanner.constraint.streams.drools.common.TriLeftHandSide;
import org.optaplanner.constraint.streams.drools.tri.DroolsAbstractTriConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadJoiner;

public final class DroolsExistsTriConstraintStream<Solution_, A, B, C>
extends DroolsAbstractTriConstraintStream<Solution_, A, B, C> {
    private final DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent;
    private final Supplier<TriLeftHandSide<A, B, C>> leftHandSide;
    private final String streamName;

    public <D> DroolsExistsTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent, boolean shouldExist, boolean shouldIncludeNullVars, Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        Predicate nullityFilter = shouldIncludeNullVars ? null : constraintFactory.getNullityFilter(otherClass);
        this.leftHandSide = () -> shouldExist ? ((TriLeftHandSide)parent.createLeftHandSide()).andExists(otherClass, joiners, nullityFilter) : ((TriLeftHandSide)parent.createLeftHandSide()).andNotExists(otherClass, joiners, nullityFilter);
        this.streamName = shouldExist ? "TriIfExists()" : "TriIfNotExists()";
    }

    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public TriLeftHandSide<A, B, C> createLeftHandSide() {
        return this.leftHandSide.get();
    }

    public String toString() {
        return this.streamName + " with " + this.getChildStreams().size() + " children";
    }
}

