/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;

public class ConstraintStreamTestExtension
implements TestTemplateInvocationContextProvider {
    public boolean supportsTestTemplate(ExtensionContext context) {
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        return Stream.of(true, false).flatMap(constraintMatchEnabled -> Arrays.stream(ConstraintStreamImplType.values()).map(constraintStreamImplType -> ConstraintStreamTestExtension.invocationContext(constraintMatchEnabled, constraintStreamImplType)));
    }

    private static TestTemplateInvocationContext invocationContext(final Boolean constraintMatchEnabled, final ConstraintStreamImplType constraintStreamImplType) {
        return new TestTemplateInvocationContext(){

            public String getDisplayName(int invocationIndex) {
                return "constraintMatchEnabled=" + constraintMatchEnabled + ", constraintStreamImplType=" + constraintStreamImplType;
            }

            public List<Extension> getAdditionalExtensions() {
                return Arrays.asList(ConstraintStreamTestExtension.parameterResolver(Boolean.TYPE, constraintMatchEnabled), ConstraintStreamTestExtension.parameterResolver(ConstraintStreamImplType.class, constraintStreamImplType));
            }
        };
    }

    private static <T> ParameterResolver parameterResolver(final Class<T> type, final T value) {
        return new ParameterResolver(){

            public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                return parameterContext.getParameter().getType().equals(type);
            }

            public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
                return value;
            }
        };
    }
}

