/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.penta.DefaultPentaJoiner;
import org.optaplanner.constraint.streams.quad.DefaultQuadJoiner;
import org.optaplanner.constraint.streams.tri.DefaultTriJoiner;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.Joiners;

class JoinersTest {
    JoinersTest() {
    }

    @Test
    void equalBi() {
        Function<BigInteger, Long> leftMapping = BigInteger::longValue;
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultBiJoiner joiner = (DefaultBiJoiner)Joiners.equal(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ONE, (Object)BigDecimal.ZERO)).isFalse();
        });
    }

    @Test
    void equalTri() {
        BiFunction<BigInteger, BigInteger, Long> leftMapping = (a, b) -> a.add((BigInteger)b).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultTriJoiner joiner = (DefaultTriJoiner)Joiners.equal(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ONE, (Object)BigInteger.ZERO, (Object)BigDecimal.ZERO)).isFalse();
        });
    }

    @Test
    void equalQuad() {
        TriFunction leftMapping = (a, b, c) -> a.add((BigInteger)b).add((BigInteger)c).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultQuadJoiner joiner = (DefaultQuadJoiner)Joiners.equal((TriFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ONE, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ZERO)).isFalse();
        });
    }

    @Test
    void equalPenta() {
        QuadFunction leftMapping = (a, b, c, d) -> a.add((BigInteger)b).add((BigInteger)c).add((BigInteger)d).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultPentaJoiner joiner = (DefaultPentaJoiner)Joiners.equal((QuadFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ONE, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ZERO)).isFalse();
        });
    }

    @Test
    void lessThanBi() {
        Function<BigInteger, Long> leftMapping = BigInteger::longValue;
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultBiJoiner joiner = (DefaultBiJoiner)Joiners.lessThan(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.TEN)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.ONE)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
        });
    }

    @Test
    void lessThanTri() {
        BiFunction<BigInteger, BigInteger, Long> leftMapping = (a, b) -> a.add((BigInteger)b).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultTriJoiner joiner = (DefaultTriJoiner)Joiners.lessThan(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
        });
    }

    @Test
    void lessThanQuad() {
        TriFunction leftMapping = (a, b, c) -> a.add((BigInteger)b).add((BigInteger)c).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultQuadJoiner joiner = (DefaultQuadJoiner)Joiners.lessThan((TriFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
        });
    }

    @Test
    void lessThanPenta() {
        QuadFunction leftMapping = (a, b, c, d) -> a.add((BigInteger)b).add((BigInteger)c).add((BigInteger)d).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultPentaJoiner joiner = (DefaultPentaJoiner)Joiners.lessThan((QuadFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
        });
    }

    @Test
    void lessThanOrEqualBi() {
        Function<BigInteger, Long> leftMapping = BigInteger::longValue;
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultBiJoiner joiner = (DefaultBiJoiner)Joiners.lessThanOrEqual(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.ONE)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
        });
    }

    @Test
    void lessThanOrEqualTri() {
        BiFunction<BigInteger, BigInteger, Long> leftMapping = (a, b) -> a.add((BigInteger)b).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultTriJoiner joiner = (DefaultTriJoiner)Joiners.lessThanOrEqual(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
        });
    }

    @Test
    void lessThanOrEqualQuad() {
        TriFunction leftMapping = (a, b, c) -> a.add((BigInteger)b).add((BigInteger)c).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultQuadJoiner joiner = (DefaultQuadJoiner)Joiners.lessThanOrEqual((TriFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
        });
    }

    @Test
    void lessThanOrEqualPenta() {
        QuadFunction leftMapping = (a, b, c, d) -> a.add((BigInteger)b).add((BigInteger)c).add((BigInteger)d).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultPentaJoiner joiner = (DefaultPentaJoiner)Joiners.lessThanOrEqual((QuadFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
        });
    }

    @Test
    void greaterThanBi() {
        Function<BigInteger, Long> leftMapping = BigInteger::longValue;
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultBiJoiner joiner = (DefaultBiJoiner)Joiners.greaterThan(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.TEN)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.ONE)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
        });
    }

    @Test
    void greaterThanTri() {
        BiFunction<BigInteger, BigInteger, Long> leftMapping = (a, b) -> a.add((BigInteger)b).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultTriJoiner joiner = (DefaultTriJoiner)Joiners.greaterThan(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
        });
    }

    @Test
    void greaterThanQuad() {
        TriFunction leftMapping = (a, b, c) -> a.add((BigInteger)b).add((BigInteger)c).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultQuadJoiner joiner = (DefaultQuadJoiner)Joiners.greaterThan((TriFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
        });
    }

    @Test
    void greaterThanPenta() {
        QuadFunction leftMapping = (a, b, c, d) -> a.add((BigInteger)b).add((BigInteger)c).add((BigInteger)d).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultPentaJoiner joiner = (DefaultPentaJoiner)Joiners.greaterThan((QuadFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isFalse();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
        });
    }

    @Test
    void greaterThanOrEqualBi() {
        Function<BigInteger, Long> leftMapping = BigInteger::longValue;
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultBiJoiner joiner = (DefaultBiJoiner)Joiners.greaterThanOrEqual(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigDecimal.ONE)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
        });
    }

    @Test
    void greaterThanOrEqualTri() {
        BiFunction<BigInteger, BigInteger, Long> leftMapping = (a, b) -> a.add((BigInteger)b).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultTriJoiner joiner = (DefaultTriJoiner)Joiners.greaterThanOrEqual(leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
        });
    }

    @Test
    void greaterThanOrEqualQuad() {
        TriFunction leftMapping = (a, b, c) -> a.add((BigInteger)b).add((BigInteger)c).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultQuadJoiner joiner = (DefaultQuadJoiner)Joiners.greaterThanOrEqual((TriFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
        });
    }

    @Test
    void greaterThanOrEqualPenta() {
        QuadFunction leftMapping = (a, b, c, d) -> a.add((BigInteger)b).add((BigInteger)c).add((BigInteger)d).longValue();
        Function<BigDecimal, Long> rightMapping = BigDecimal::longValue;
        DefaultPentaJoiner joiner = (DefaultPentaJoiner)Joiners.greaterThanOrEqual((QuadFunction)leftMapping, rightMapping);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.TEN)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.TEN, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isTrue();
            softly.assertThat(joiner.matches((Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigInteger.ZERO, (Object)BigDecimal.ONE)).isFalse();
        });
    }

    @Test
    void overlapsBiDifferentTypes() {
        Function<Interval, Long> leftStartMapping = interval -> ((BigInteger)interval.getStart()).longValue();
        Function<Interval, Long> leftEndMapping = interval -> ((BigInteger)interval.getEnd()).longValue();
        Function<Interval, Long> rightStartMapping = interval -> ((BigDecimal)interval.getStart()).longValue();
        Function<Interval, Long> rightEndMapping = interval -> ((BigDecimal)interval.getEnd()).longValue();
        DefaultBiJoiner joiner = (DefaultBiJoiner)Joiners.overlapping(leftStartMapping, leftEndMapping, rightStartMapping, rightEndMapping);
        SoftAssertions.assertSoftly(softly -> {
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), Interval.ofBigDecimal(1L, 5L))).as("Case A = B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), Interval.ofBigDecimal(1L, 5L))).as("B starts before A, A ends after B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), Interval.ofBigDecimal(3L, 7L))).as("A starts before B, B ends after A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 5L), Interval.ofBigDecimal(1L, 7L))).as("B contains A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), Interval.ofBigDecimal(3L, 5L))).as("A contains B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), Interval.ofBigDecimal(1L, 3L))).as("A started by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), Interval.ofBigDecimal(1L, 7L))).as("B started by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), Interval.ofBigDecimal(3L, 7L))).as("A ended by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), Interval.ofBigDecimal(1L, 7L))).as("B ended by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), Interval.ofBigDecimal(5L, 7L))).as("A before B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(5L, 7L), Interval.ofBigDecimal(1L, 3L))).as("B before A", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), Interval.ofBigDecimal(3L, 7L))).as("A meets B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), Interval.ofBigDecimal(1L, 3L))).as("B meets A", new Object[0])).isFalse();
        });
    }

    @Test
    void overlapsBiSameTypes() {
        Function<Interval, Long> leftStartMapping = interval -> ((BigInteger)interval.getStart()).longValue();
        Function<Interval, Long> leftEndMapping = interval -> ((BigInteger)interval.getEnd()).longValue();
        DefaultBiJoiner joiner = (DefaultBiJoiner)Joiners.overlapping(leftStartMapping, leftEndMapping);
        SoftAssertions.assertSoftly(softly -> {
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), Interval.ofBigInt(1L, 5L))).as("Case A = B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), Interval.ofBigInt(1L, 5L))).as("B starts before A, A ends after B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), Interval.ofBigInt(3L, 7L))).as("A starts before B, B ends after A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 5L), Interval.ofBigInt(1L, 7L))).as("B contains A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), Interval.ofBigInt(3L, 5L))).as("A contains B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), Interval.ofBigInt(1L, 3L))).as("A started by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), Interval.ofBigInt(1L, 7L))).as("B started by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), Interval.ofBigInt(3L, 7L))).as("A ended by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), Interval.ofBigInt(1L, 7L))).as("B ended by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), Interval.ofBigInt(5L, 7L))).as("A before B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(5L, 7L), Interval.ofBigInt(1L, 3L))).as("B before A", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), Interval.ofBigInt(3L, 7L))).as("A meets B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), Interval.ofBigInt(1L, 3L))).as("B meets A", new Object[0])).isFalse();
        });
    }

    @Test
    void overlapsTri() {
        BiFunction<Interval, String, Long> leftStartMapping = (interval, ignored) -> ((BigInteger)interval.getStart()).longValue();
        BiFunction<Interval, String, Long> leftEndMapping = (interval, ignored) -> ((BigInteger)interval.getEnd()).longValue();
        Function<Interval, Long> rightStartMapping = interval -> ((BigDecimal)interval.getStart()).longValue();
        Function<Interval, Long> rightEndMapping = interval -> ((BigDecimal)interval.getEnd()).longValue();
        DefaultTriJoiner joiner = (DefaultTriJoiner)Joiners.overlapping(leftStartMapping, leftEndMapping, rightStartMapping, rightEndMapping);
        SoftAssertions.assertSoftly(softly -> {
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 5L))).as("Case A = B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 5L))).as("B starts before A, A ends after B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A starts before B, B ends after A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 5L), (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B contains A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 5L))).as("A contains B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("A started by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B started by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A ended by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B ended by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", Interval.ofBigDecimal(5L, 7L))).as("A before B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(5L, 7L), (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("B before A", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A meets B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("B meets A", new Object[0])).isFalse();
        });
    }

    @Test
    void overlapsQuad() {
        TriFunction leftStartMapping = (interval, ignored1, ignored2) -> ((BigInteger)interval.getStart()).longValue();
        TriFunction leftEndMapping = (interval, ignored1, ignored2) -> ((BigInteger)interval.getEnd()).longValue();
        Function<Interval, Long> rightStartMapping = interval -> ((BigDecimal)interval.getStart()).longValue();
        Function<Interval, Long> rightEndMapping = interval -> ((BigDecimal)interval.getEnd()).longValue();
        DefaultQuadJoiner joiner = (DefaultQuadJoiner)Joiners.overlapping((TriFunction)leftStartMapping, (TriFunction)leftEndMapping, rightStartMapping, rightEndMapping);
        SoftAssertions.assertSoftly(softly -> {
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 5L))).as("Case A = B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 5L))).as("B starts before A, A ends after B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A starts before B, B ends after A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 5L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B contains A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 5L))).as("A contains B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("A started by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B started by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A ended by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B ended by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(5L, 7L))).as("A before B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(5L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("B before A", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A meets B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("B meets A", new Object[0])).isFalse();
        });
    }

    @Test
    void overlapsPenta() {
        QuadFunction leftStartMapping = (interval, ignored1, ignored2, ignored3) -> ((BigInteger)interval.getStart()).longValue();
        QuadFunction leftEndMapping = (interval, ignored1, ignored2, ignored3) -> ((BigInteger)interval.getEnd()).longValue();
        Function<Interval, Long> rightStartMapping = interval -> ((BigDecimal)interval.getStart()).longValue();
        Function<Interval, Long> rightEndMapping = interval -> ((BigDecimal)interval.getEnd()).longValue();
        DefaultPentaJoiner joiner = (DefaultPentaJoiner)Joiners.overlapping((QuadFunction)leftStartMapping, (QuadFunction)leftEndMapping, rightStartMapping, rightEndMapping);
        SoftAssertions.assertSoftly(softly -> {
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 5L))).as("Case A = B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 5L))).as("B starts before A, A ends after B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 5L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A starts before B, B ends after A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 5L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B contains A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 5L))).as("A contains B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("A started by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B started by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A ended by B", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 7L))).as("B ended by A", new Object[0])).isTrue();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(5L, 7L))).as("A before B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(5L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("B before A", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(1L, 3L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(3L, 7L))).as("A meets B", new Object[0])).isFalse();
            ((BooleanAssert)softly.assertThat(joiner.matches(Interval.ofBigInt(3L, 7L), (Object)"Ignored Arg", (Object)"Ignored Arg", (Object)"Ignored Arg", Interval.ofBigDecimal(1L, 3L))).as("B meets A", new Object[0])).isFalse();
        });
    }

    private static final class Interval<A, B> {
        final A start;
        final A end;
        final Function<A, B> map;

        public Interval(A start, A end, Function<A, B> map) {
            this.start = start;
            this.end = end;
            this.map = map;
        }

        public B getStart() {
            return this.map.apply(this.start);
        }

        public B getEnd() {
            return this.map.apply(this.end);
        }

        public String toString() {
            return "(" + this.start.toString() + ", " + this.end.toString() + ")";
        }

        public static Interval<Long, BigDecimal> ofBigDecimal(Long start, Long end) {
            return new Interval<Long, BigDecimal>(start, end, BigDecimal::valueOf);
        }

        public static Interval<Long, BigInteger> ofBigInt(Long start, Long end) {
            return new Interval<Long, BigInteger>(start, end, BigInteger::valueOf);
        }
    }
}

