/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBiTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;

public final class BavetGroupBiNode<GroupKey_, ResultContainer_, Result_>
extends BavetAbstractBiNode<GroupKey_, Result_> {
    private final Function<ResultContainer_, Result_> finisher;
    private final List<BavetAbstractBiNode<GroupKey_, Result_>> childNodeList = new ArrayList<BavetAbstractBiNode<GroupKey_, Result_>>();

    public BavetGroupBiNode(BavetConstraintSession session, int nodeIndex, Function<ResultContainer_, Result_> finisher) {
        super(session, nodeIndex);
        this.finisher = finisher;
    }

    @Override
    public void addChildNode(BavetAbstractBiNode<GroupKey_, Result_> childNode) {
        this.childNodeList.add(childNode);
    }

    @Override
    public List<BavetAbstractBiNode<GroupKey_, Result_>> getChildNodeList() {
        return this.childNodeList;
    }

    public BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_> createTuple(BavetAbstractBiTuple<GroupKey_, Result_> parentTuple) {
        throw new IllegalStateException("The Grouped node (" + this.getClass().getSimpleName() + ") can't have a parentTuple (" + parentTuple + ");");
    }

    public BavetGroupBiTuple<GroupKey_, ResultContainer_, Result_> createTuple(GroupKey_ groupKey, ResultContainer_ resultContainer) {
        return new BavetGroupBiTuple(this, groupKey, resultContainer);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetGroupBiTuple tuple = (BavetGroupBiTuple)uncastTuple;
        List<BavetAbstractTuple> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractTuple bavetAbstractTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive()) {
            tuple.updateResult(this.finisher);
            for (BavetAbstractBiNode bavetAbstractBiNode : this.childNodeList) {
                BavetAbstractBiTuple childTuple = bavetAbstractBiNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public String toString() {
        return "Group() with " + this.childNodeList.size() + " children";
    }
}

