/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiTuple;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBiNode;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBiTuple;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBridgeBiTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;

public class BavetGroupBridgeBiNode<A, B, NewA, ResultContainer_, NewB>
extends BavetAbstractBiNode<A, B> {
    private final BiFunction<A, B, NewA> groupKeyMapping;
    private final BiConstraintCollector<A, B, ResultContainer_, NewB> collector;
    private BavetGroupBiNode<NewA, ResultContainer_, NewB> groupNode;
    private final Map<NewA, BavetGroupBiTuple<NewA, ResultContainer_, NewB>> tupleMap;

    public BavetGroupBridgeBiNode(BavetConstraintSession session, int nodeIndex, BavetAbstractBiNode<A, B> parentNode, BiFunction<A, B, NewA> groupKeyMapping, BiConstraintCollector<A, B, ResultContainer_, NewB> collector) {
        super(session, nodeIndex);
        this.groupKeyMapping = groupKeyMapping;
        this.collector = collector;
        this.tupleMap = new HashMap<NewA, BavetGroupBiTuple<NewA, ResultContainer_, NewB>>();
    }

    public BavetGroupBridgeBiTuple<A, B, NewA, ResultContainer_, NewB> createTuple(BavetAbstractBiTuple<A, B> parentTuple) {
        return new BavetGroupBridgeBiTuple(this, parentTuple);
    }

    public void setGroupNode(BavetGroupBiNode<NewA, ResultContainer_, NewB> groupNode) {
        this.groupNode = groupNode;
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        if (this.groupNode == null) {
            throw new IllegalStateException("Impossible state: GroupBridgeNode (" + this + ") has no child GroupNode (" + this.groupNode + ").");
        }
        BavetGroupBridgeBiTuple tuple = (BavetGroupBridgeBiTuple)uncastTuple;
        if (tuple.getChildTuple() != null) {
            BavetGroupBiTuple childTuple = tuple.getChildTuple();
            Object oldGroupKey = childTuple.getGroupKey();
            int parentCount = childTuple.decreaseParentCount();
            tuple.getUndoAccumulator().run();
            childTuple.clearResult();
            tuple.setChildTuple(null);
            tuple.setUndoAccumulator(null);
            if (parentCount == 0) {
                this.tupleMap.remove(oldGroupKey);
                this.session.transitionTuple(childTuple, BavetTupleState.DYING);
            } else {
                this.session.transitionTuple(childTuple, BavetTupleState.UPDATING);
            }
        }
        if (tuple.isActive()) {
            Object a = tuple.getFactA();
            Object b = tuple.getFactB();
            NewA groupKey = this.groupKeyMapping.apply(a, b);
            BavetGroupBiTuple childTuple = this.tupleMap.computeIfAbsent(groupKey, k -> this.groupNode.createTuple(groupKey, this.collector.supplier().get()));
            int parentCount = childTuple.increaseParentCount();
            Runnable undoAccumulator = (Runnable)this.collector.accumulator().apply(childTuple.getResultContainer(), a, b);
            tuple.setUndoAccumulator(undoAccumulator);
            childTuple.clearResult();
            tuple.setChildTuple(childTuple);
            if (parentCount == 1) {
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            } else if (childTuple.getState() != BavetTupleState.CREATING) {
                this.session.transitionTuple(childTuple, BavetTupleState.UPDATING);
            }
        }
    }

    public String toString() {
        return "GroupBridge()";
    }
}

