/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiNode;
import org.optaplanner.constraint.streams.bavet.bi.BavetJoinBiNode;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetFromUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniNode;
import org.optaplanner.core.api.score.Score;

public final class BavetJoinBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetAbstractUniConstraintStream<Solution_, A> leftParent;
    private final BavetAbstractUniConstraintStream<Solution_, B> rightParent;

    public BavetJoinBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> leftParent, BavetAbstractUniConstraintStream<Solution_, B> rightParent) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public List<BavetFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return Stream.concat(this.leftParent.getFromStreamList().stream(), this.rightParent.getFromStreamList().stream()).collect(Collectors.toList());
    }

    @Override
    public BavetJoinBiNode<A, B> createNodeChain(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetJoinBridgeNode leftNode_, BavetJoinBridgeNode rightNode_) {
        BavetJoinBridgeUniNode leftNode = (BavetJoinBridgeUniNode)leftNode_;
        BavetJoinBridgeUniNode rightNode = (BavetJoinBridgeUniNode)rightNode_;
        BavetJoinBiNode node = new BavetJoinBiNode(buildPolicy.getSession(), buildPolicy.nextNodeIndex(), leftNode, rightNode);
        leftNode.setChildTupleRefresher(node::refreshChildTuplesLeft);
        rightNode.setChildTupleRefresher(node::refreshChildTuplesRight);
        node = (BavetJoinBiNode)this.processNode(buildPolicy, null, node);
        this.createChildNodeChains(buildPolicy, constraintWeight, node);
        return node;
    }

    @Override
    protected BavetJoinBiNode<A, B> createNode(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractBiNode<A, B> parentNode) {
        throw new IllegalStateException("Impossible state: this code is never called.");
    }

    public String toString() {
        return "Join() with " + this.childStreamList.size() + " children";
    }
}

