/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import org.optaplanner.constraint.streams.bavet.common.BavetJoinBridgeTuple;
import org.optaplanner.constraint.streams.bavet.common.index.BavetEqualsAndComparisonIndex;
import org.optaplanner.constraint.streams.bavet.common.index.BavetEqualsIndex;
import org.optaplanner.constraint.streams.bavet.common.index.BavetIndex;
import org.optaplanner.constraint.streams.bavet.common.index.BavetNoneIndex;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.JoinerType;

public class BavetIndexFactory {
    private final JoinerType[] joinerTypes;

    public BavetIndexFactory(AbstractJoiner joiner) {
        int joinerCount = joiner.getJoinerCount();
        this.joinerTypes = new JoinerType[joinerCount];
        for (int i = 0; i < joinerCount; ++i) {
            JoinerType joinerType = joiner.getJoinerType(i);
            switch (joinerType) {
                case EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported joiner type (" + joinerType + ").");
                }
            }
            if (joinerType != JoinerType.EQUAL && i != joinerCount - 1) {
                JoinerType nextJoinerType = joiner.getJoinerType(i + 1);
                throw new IllegalArgumentException("The joinerType (" + joinerType + ") is currently only supported as the last joinerType.\n" + (nextJoinerType == JoinerType.EQUAL ? "Maybe move the next joinerType (" + nextJoinerType + ") before this joinerType (" + joinerType + ")." : "Maybe put the next joinerType (" + nextJoinerType + ") in a filter() predicate after the join() call for now."));
            }
            this.joinerTypes[i] = joiner.getJoinerType(i);
        }
    }

    public <Tuple_ extends BavetJoinBridgeTuple> BavetIndex<Tuple_> buildIndex(boolean isLeftBridge) {
        if (this.joinerTypes.length == 0) {
            return new BavetNoneIndex();
        }
        JoinerType lastJoinerType = this.joinerTypes[this.joinerTypes.length - 1];
        if (lastJoinerType == JoinerType.EQUAL) {
            return new BavetEqualsIndex();
        }
        return new BavetEqualsAndComparisonIndex(isLeftBridge ? lastJoinerType : lastJoinerType.flip());
    }
}

