/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.bi.BavetJoinBridgeBiNode;
import org.optaplanner.constraint.streams.bavet.bi.BavetJoinBridgeBiTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.index.BavetIndex;
import org.optaplanner.constraint.streams.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.constraint.streams.bavet.tri.BavetAbstractTriTuple;
import org.optaplanner.constraint.streams.bavet.tri.BavetJoinTriTuple;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniTuple;

public final class BavetJoinTriNode<A, B, C>
extends BavetAbstractTriNode<A, B, C>
implements BavetJoinNode {
    private final BavetJoinBridgeBiNode<A, B> leftParentNode;
    private final BavetJoinBridgeUniNode<C> rightParentNode;
    private final List<BavetAbstractTriNode<A, B, C>> childNodeList = new ArrayList<BavetAbstractTriNode<A, B, C>>();

    public BavetJoinTriNode(BavetConstraintSession session, int nodeIndex, BavetJoinBridgeBiNode<A, B> leftParentNode, BavetJoinBridgeUniNode<C> rightParentNode) {
        super(session, nodeIndex);
        this.leftParentNode = leftParentNode;
        this.rightParentNode = rightParentNode;
    }

    @Override
    public void addChildNode(BavetAbstractTriNode<A, B, C> childNode) {
        this.childNodeList.add(childNode);
    }

    @Override
    public List<BavetAbstractTriNode<A, B, C>> getChildNodeList() {
        return this.childNodeList;
    }

    @Override
    public BavetJoinTriTuple<A, B, C> createTuple(BavetAbstractTriTuple<A, B, C> parentTuple) {
        throw new IllegalStateException("The join node (" + this.getClass().getSimpleName() + ") can't have a parentTuple (" + parentTuple + ");");
    }

    public BavetJoinTriTuple<A, B, C> createTuple(BavetJoinBridgeBiTuple<A, B> abTuple, BavetJoinBridgeUniTuple<C> cTuple) {
        return new BavetJoinTriTuple<A, B, C>(this, abTuple, cTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetJoinTriTuple tuple = (BavetJoinTriTuple)uncastTuple;
        List<BavetAbstractTuple> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractTuple bavetAbstractTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive()) {
            for (BavetAbstractTriNode bavetAbstractTriNode : this.childNodeList) {
                BavetAbstractTriTuple childTuple = bavetAbstractTriNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public void refreshChildTuplesLeft(BavetJoinBridgeBiTuple<A, B> leftParentTuple) {
        List<BavetAbstractTuple> leftTupleSet = leftParentTuple.getChildTupleList();
        for (BavetAbstractTuple tuple_ : leftTupleSet) {
            BavetJoinTriTuple tuple = (BavetJoinTriTuple)tuple_;
            boolean removed = tuple.getCTuple().getChildTupleList().remove(tuple);
            if (!removed) {
                throw new IllegalStateException("Impossible state: the facts (" + tuple.getFactA() + ", " + tuple.getFactB() + ")'s tuple cannot be removed from the other fact (" + tuple.getFactC() + ")'s join bridge.");
            }
            this.session.transitionTuple(tuple, BavetTupleState.DYING);
        }
        leftTupleSet.clear();
        if (leftParentTuple.isActive()) {
            Set<BavetJoinBridgeUniTuple<C>> rightParentTupleList = this.getRightIndex().get(leftParentTuple.getIndexProperties());
            for (BavetJoinBridgeUniTuple<C> rightParentTuple : rightParentTupleList) {
                if (rightParentTuple.isDirty()) continue;
                BavetJoinTriTuple<A, B, C> childTuple = this.createTuple(leftParentTuple, rightParentTuple);
                leftTupleSet.add(childTuple);
                rightParentTuple.getChildTupleList().add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public void refreshChildTuplesRight(BavetJoinBridgeUniTuple<C> rightParentTuple) {
        List<BavetAbstractTuple> rightTupleSet = rightParentTuple.getChildTupleList();
        for (BavetAbstractTuple uncastTuple : rightTupleSet) {
            BavetJoinTriTuple tuple = (BavetJoinTriTuple)uncastTuple;
            boolean removed = tuple.getAbTuple().getChildTupleList().remove(tuple);
            if (!removed) {
                throw new IllegalStateException("Impossible state: the fact (" + tuple.getFactC() + ")'s tuple cannot be removed from the other facts (" + tuple.getFactA() + ", " + tuple.getFactB() + ")'s join bridge.");
            }
            this.session.transitionTuple(tuple, BavetTupleState.DYING);
        }
        rightTupleSet.clear();
        if (rightParentTuple.isActive()) {
            Set<BavetJoinBridgeBiTuple<A, B>> leftParentTupleList = this.getLeftIndex().get(rightParentTuple.getIndexProperties());
            for (BavetJoinBridgeBiTuple<A, B> leftParentTuple : leftParentTupleList) {
                if (leftParentTuple.isDirty()) continue;
                BavetJoinTriTuple<A, B, C> childTuple = this.createTuple(leftParentTuple, rightParentTuple);
                leftParentTuple.getChildTupleList().add(childTuple);
                rightTupleSet.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public BavetIndex<BavetJoinBridgeBiTuple<A, B>> getLeftIndex() {
        return this.leftParentNode.getIndex();
    }

    public BavetIndex<BavetJoinBridgeUniTuple<C>> getRightIndex() {
        return this.rightParentNode.getIndex();
    }

    public String toString() {
        return "Join() with " + this.childNodeList.size() + " children";
    }
}

