/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BavetJoinBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.constraint.streams.bavet.common.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.common.index.BavetIndexFactory;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetFilterUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetGroupBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetScoringUniConstraintStream;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.bi.FilteringBiJoiner;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.constraint.streams.uni.InnerUniConstraintStream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;

public abstract class BavetAbstractUniConstraintStream<Solution_, A>
extends BavetAbstractConstraintStream<Solution_>
implements InnerUniConstraintStream<A> {
    protected final List<BavetAbstractUniConstraintStream<Solution_, A>> childStreamList = new ArrayList<BavetAbstractUniConstraintStream<Solution_, A>>(2);

    public BavetAbstractUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, RetrievalSemantics retrievalSemantics) {
        super(constraintFactory, retrievalSemantics);
    }

    public void addChildStream(BavetAbstractUniConstraintStream<Solution_, A> childStream) {
        this.childStreamList.add(childStream);
    }

    public BavetAbstractUniConstraintStream<Solution_, A> filter(Predicate<A> predicate) {
        BavetFilterUniConstraintStream stream = new BavetFilterUniConstraintStream(this.constraintFactory, this, predicate);
        this.childStreamList.add(stream);
        return stream;
    }

    public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner) {
        if (!(otherStream instanceof BavetAbstractUniConstraintStream)) {
            throw new IllegalStateException("The streams (" + this + ", " + otherStream + ") are not build from the same " + ConstraintFactory.class.getSimpleName() + ".");
        }
        BavetAbstractUniConstraintStream other = (BavetAbstractUniConstraintStream)otherStream;
        if (this.constraintFactory != other.getConstraintFactory()) {
            throw new IllegalStateException("The streams (" + this + ", " + other + ") are build from different constraintFactories (" + this.constraintFactory + ", " + (BavetConstraintFactory)other.getConstraintFactory() + ").");
        }
        if (joiner instanceof FilteringBiJoiner) {
            return this.join(otherStream).filter(((FilteringBiJoiner)joiner).getFilter());
        }
        if (!(joiner instanceof DefaultBiJoiner)) {
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        DefaultBiJoiner castedJoiner = (DefaultBiJoiner)joiner;
        BavetIndexFactory indexFactory = new BavetIndexFactory(castedJoiner);
        BavetJoinBridgeUniConstraintStream leftBridge = new BavetJoinBridgeUniConstraintStream(this.constraintFactory, this, true, JoinerUtils.combineLeftMappings(castedJoiner), indexFactory);
        this.childStreamList.add(leftBridge);
        BavetJoinBridgeUniConstraintStream rightBridge = new BavetJoinBridgeUniConstraintStream(this.constraintFactory, other, false, JoinerUtils.combineRightMappings(castedJoiner), indexFactory);
        other.childStreamList.add(rightBridge);
        BavetJoinBiConstraintStream joinStream = new BavetJoinBiConstraintStream(this.constraintFactory, leftBridge, rightBridge);
        leftBridge.setJoinStream(joinStream);
        rightBridge.setJoinStream(joinStream);
        return joinStream;
    }

    @Override
    public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.join(this.constraintFactory.forEach(otherClass), joiners);
        }
        return this.join(this.constraintFactory.from(otherClass), joiners);
    }

    @SafeVarargs
    public final <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> collectorA, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> collectorA, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> collectorA, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC, UniConstraintCollector<A, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(Function<A, GroupKey_> groupKeyMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(Function<A, GroupKey_> groupKeyMapping, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(Function<A, GroupKey_> groupKeyMapping, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC, UniConstraintCollector<A, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(Function<A, GroupKey_> groupKeyMapping, UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        BavetGroupBridgeUniConstraintStream bridge = new BavetGroupBridgeUniConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.childStreamList.add(bridge);
        BavetGroupBiConstraintStream groupStream = new BavetGroupBiConstraintStream(this.constraintFactory, bridge, collector.finisher());
        bridge.setGroupStream(groupStream);
        return groupStream;
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC, UniConstraintCollector<A, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, Function<A, GroupKeyC_> groupKeyCMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, Function<A, GroupKeyC_> groupKeyCMapping, UniConstraintCollector<A, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, Function<A, GroupKeyC_> groupKeyCMapping, Function<A, GroupKeyD_> groupKeyDMapping) {
        throw new UnsupportedOperationException();
    }

    public <ResultA_> UniConstraintStream<ResultA_> map(Function<A, ResultA_> mapping) {
        throw new UnsupportedOperationException();
    }

    public <ResultA_> UniConstraintStream<ResultA_> flattenLast(Function<A, Iterable<ResultA_>> mapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    @Override
    public final Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        BavetConstraint constraint = this.buildConstraintConfigurable(constraintPackage, constraintName, impactType);
        BavetScoringUniConstraintStream stream = new BavetScoringUniConstraintStream(this.constraintFactory, this, constraint, matchWeigher);
        this.childStreamList.add(stream);
        return constraint;
    }

    public BavetAbstractUniNode<A> createNodeChain(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractUniNode<A> parentNode) {
        BavetAbstractUniNode<A> node = this.createNode(buildPolicy, constraintWeight, parentNode);
        node = this.processNode(buildPolicy, parentNode, node);
        this.createChildNodeChains(buildPolicy, constraintWeight, node);
        return node;
    }

    protected BavetAbstractUniNode<A> processNode(BavetNodeBuildPolicy<Solution_> buildPolicy, BavetAbstractUniNode<A> parentNode, BavetAbstractUniNode<A> node) {
        BavetAbstractUniNode<A> sharedNode = buildPolicy.retrieveSharedNode(node);
        if (sharedNode != node) {
            return sharedNode;
        }
        if (parentNode != null) {
            parentNode.addChildNode(node);
        }
        return node;
    }

    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, BavetAbstractUniNode<A> node) {
        if (this.childStreamList.isEmpty()) {
            throw new IllegalStateException("The stream (" + this + ") leads to nowhere.\nMaybe don't create it.");
        }
        for (BavetAbstractUniConstraintStream<Solution_, A> childStream : this.childStreamList) {
            childStream.createNodeChain(buildPolicy, constraintWeight, node);
        }
    }

    protected abstract BavetAbstractUniNode<A> createNode(BavetNodeBuildPolicy<Solution_> var1, Score<?> var2, BavetAbstractUniNode<A> var3);
}

