/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetScoringNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.constraint.streams.bavet.uni.BavetScoringUniTuple;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.Score;

public final class BavetScoringUniNode<A>
extends BavetAbstractUniNode<A>
implements BavetScoringNode {
    private final Score<?> constraintWeight;
    private final Function<A, UndoScoreImpacter> scoreImpacter;

    public BavetScoringUniNode(BavetConstraintSession session, int nodeIndex, Score<?> constraintWeight, Function<A, UndoScoreImpacter> scoreImpacter) {
        super(session, nodeIndex);
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
    }

    @Override
    public List<BavetAbstractUniNode<A>> getChildNodeList() {
        return Collections.emptyList();
    }

    @Override
    public BavetScoringUniTuple<A> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        return new BavetScoringUniTuple<A>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetScoringUniTuple tuple = (BavetScoringUniTuple)uncastTuple;
        Object a = tuple.getFactA();
        UndoScoreImpacter oldUndoScoreImpacter = tuple.getUndoScoreImpacter();
        if (oldUndoScoreImpacter != null) {
            oldUndoScoreImpacter.run();
        }
        if (tuple.isActive()) {
            UndoScoreImpacter undoScoreImpacter = this.scoreImpacter.apply(a);
            tuple.setUndoScoreImpacter(undoScoreImpacter);
        } else {
            tuple.setUndoScoreImpacter(null);
        }
    }

    public String toString() {
        return "Scoring(" + this.constraintWeight + ")";
    }
}

