/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bi;

import java.util.Arrays;
import java.util.function.Function;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.impl.score.stream.JoinerType;

public final class DefaultBiJoiner<A, B>
extends AbstractJoiner<B>
implements BiJoiner<A, B> {
    public static final BiJoiner NONE = new DefaultBiJoiner(new Function[0], new JoinerType[0], new Function[0]);
    private final Function<A, ?>[] leftMappings;

    public <Property_> DefaultBiJoiner(Function<A, Property_> leftMapping, JoinerType joinerType, Function<B, Property_> rightMapping) {
        super(rightMapping, joinerType);
        this.leftMappings = new Function[]{leftMapping};
    }

    private <Property_> DefaultBiJoiner(Function<A, Property_>[] leftMappings, JoinerType[] joinerTypes, Function<B, Property_>[] rightMappings) {
        super(rightMappings, joinerTypes);
        this.leftMappings = leftMappings;
    }

    public DefaultBiJoiner<A, B> and(BiJoiner<A, B> otherJoiner) {
        DefaultBiJoiner castJoiner = (DefaultBiJoiner)otherJoiner;
        int joinerCount = this.getJoinerCount();
        int castJoinerCount = castJoiner.getJoinerCount();
        int newJoinerCount = joinerCount + castJoinerCount;
        JoinerType[] newJoinerTypes = Arrays.copyOf(this.joinerTypes, newJoinerCount);
        Function<A, ?>[] newLeftMappings = Arrays.copyOf(this.leftMappings, newJoinerCount);
        Function[] newRightMappings = Arrays.copyOf(this.rightMappings, newJoinerCount);
        for (int i = 0; i < castJoinerCount; ++i) {
            int newJoinerIndex = i + joinerCount;
            newJoinerTypes[newJoinerIndex] = castJoiner.getJoinerType(i);
            newLeftMappings[newJoinerIndex] = castJoiner.getLeftMapping(i);
            newRightMappings[newJoinerIndex] = castJoiner.getRightMapping(i);
        }
        return new DefaultBiJoiner<A, B>(newLeftMappings, newJoinerTypes, newRightMappings);
    }

    public Function<A, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    public boolean matches(A a, B b) {
        int joinerCount = this.getJoinerCount();
        for (int i = 0; i < joinerCount; ++i) {
            Object rightMapping;
            Object leftMapping;
            JoinerType joinerType = this.getJoinerType(i);
            if (joinerType.matches(leftMapping = this.getLeftMapping(i).apply(a), rightMapping = this.getRightMapping(i).apply(b))) continue;
            return false;
        }
        return true;
    }
}

