/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.penta;

import java.util.Arrays;
import java.util.function.Function;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.score.stream.penta.PentaJoiner;
import org.optaplanner.core.impl.score.stream.JoinerType;

public final class DefaultPentaJoiner<A, B, C, D, E>
extends AbstractJoiner<E>
implements PentaJoiner<A, B, C, D, E> {
    public static final DefaultPentaJoiner NONE = new DefaultPentaJoiner(new QuadFunction[0], new JoinerType[0], new Function[0]);
    private final QuadFunction<A, B, C, D, ?>[] leftMappings;

    public <Property_> DefaultPentaJoiner(QuadFunction<A, B, C, D, Property_> leftMapping, JoinerType joinerType, Function<E, Property_> rightMapping) {
        super(rightMapping, joinerType);
        this.leftMappings = new QuadFunction[]{leftMapping};
    }

    private <Property_> DefaultPentaJoiner(QuadFunction<A, B, C, D, Property_>[] leftMappings, JoinerType[] joinerTypes, Function<E, Property_>[] rightMappings) {
        super(rightMappings, joinerTypes);
        this.leftMappings = leftMappings;
    }

    public DefaultPentaJoiner<A, B, C, D, E> and(PentaJoiner<A, B, C, D, E> otherJoiner) {
        DefaultPentaJoiner castJoiner = (DefaultPentaJoiner)otherJoiner;
        int joinerCount = this.getJoinerCount();
        int castJoinerCount = castJoiner.getJoinerCount();
        int newJoinerCount = joinerCount + castJoinerCount;
        JoinerType[] newJoinerTypes = Arrays.copyOf(this.joinerTypes, newJoinerCount);
        QuadFunction<A, B, C, D, ?>[] newLeftMappings = Arrays.copyOf(this.leftMappings, newJoinerCount);
        Function[] newRightMappings = Arrays.copyOf(this.rightMappings, newJoinerCount);
        for (int i = 0; i < castJoinerCount; ++i) {
            int newJoinerIndex = i + joinerCount;
            newJoinerTypes[newJoinerIndex] = castJoiner.getJoinerType(i);
            newLeftMappings[newJoinerIndex] = castJoiner.getLeftMapping(i);
            newRightMappings[newJoinerIndex] = castJoiner.getRightMapping(i);
        }
        return new DefaultPentaJoiner<A, B, C, D, E>(newLeftMappings, newJoinerTypes, newRightMappings);
    }

    public QuadFunction<A, B, C, D, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    public boolean matches(A a, B b, C c, D d, E e) {
        int joinerCount = this.getJoinerCount();
        for (int i = 0; i < joinerCount; ++i) {
            Object rightMapping;
            Object leftMapping;
            JoinerType joinerType = this.getJoinerType(i);
            if (joinerType.matches(leftMapping = this.getLeftMapping(i).apply(a, b, c, d), rightMapping = this.getRightMapping(i).apply(e))) continue;
            return false;
        }
        return true;
    }
}

