/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.SimpleLongScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataSimpleLongScoreSolution;

class SimpleLongScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataSimpleLongScoreSolution, SimpleLongScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    SimpleLongScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(SimpleLongScore.ONE);
        SimpleLongScoreInliner scoreInliner = new SimpleLongScoreInliner(this.getConstaintToWeightMap(constraint), true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleLongScore.ZERO);
    }

    @Test
    void impact() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(SimpleLongScore.of((long)10L));
        SimpleLongScoreInliner scoreInliner = new SimpleLongScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleLongScore.of((long)100L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleLongScore.of((long)300L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleLongScore.of((long)100L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleLongScore.of((long)0L));
    }

    @Override
    protected SolutionDescriptor<TestdataSimpleLongScoreSolution> buildSolutionDescriptor() {
        return TestdataSimpleLongScoreSolution.buildSolutionDescriptor();
    }
}

