/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.uni;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.optaplanner.constraint.streams.AbstractConstraintStreamTest;
import org.optaplanner.constraint.streams.ConstraintStreamFunctionalTest;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataObject;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntity;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntityGroup;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishSolution;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValue;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValueGroup;

public class UniConstraintStreamTest
extends AbstractConstraintStreamTest
implements ConstraintStreamFunctionalTest {
    public UniConstraintStreamTest(boolean constraintMatchEnabled, ConstraintStreamImplType constraintStreamImplType) {
        super(constraintMatchEnabled, constraintStreamImplType);
    }

    @TestTemplate
    public void filter_problemFact() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        TestdataLavishValueGroup valueGroup1 = new TestdataLavishValueGroup("MyValueGroup 1");
        solution.getValueGroupList().add(valueGroup1);
        TestdataLavishValueGroup valueGroup2 = new TestdataLavishValueGroup("MyValueGroup 2");
        solution.getValueGroupList().add(valueGroup2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishValueGroup.class).filter(valueGroup -> valueGroup.getCode().startsWith("MyValueGroup")).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(valueGroup1), UniConstraintStreamTest.assertMatch(valueGroup2));
        scoreDirector.beforeProblemPropertyChanged((Object)valueGroup1);
        valueGroup1.setCode("Other code");
        scoreDirector.afterProblemPropertyChanged((Object)valueGroup1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(valueGroup2));
    }

    @Override
    @TestTemplate
    public void filter_entity() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution();
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).filter(entity -> entity.getEntityGroup() == entityGroup).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
        scoreDirector.beforeProblemPropertyChanged((Object)entity3);
        entity3.setEntityGroup(entityGroup);
        scoreDirector.afterProblemPropertyChanged((Object)entity3);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2), UniConstraintStreamTest.assertMatch(entity3));
        scoreDirector.beforeEntityRemoved((Object)entity3);
        solution.getEntityList().remove(entity3);
        scoreDirector.afterEntityRemoved((Object)entity3);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
        scoreDirector.beforeEntityAdded((Object)entity3);
        solution.getEntityList().add(entity3);
        scoreDirector.afterEntityAdded((Object)entity3);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2), UniConstraintStreamTest.assertMatch(entity3));
    }

    @Override
    @TestTemplate
    public void filter_consecutive() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)4, (int)4);
        TestdataLavishEntity entity1 = (TestdataLavishEntity)solution.getEntityList().get(0);
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntity entity4 = (TestdataLavishEntity)solution.getEntityList().get(3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).filter(entity -> !Objects.equals(entity, entity1)).filter(entity -> !Objects.equals(entity, entity2)).filter(entity -> !Objects.equals(entity, entity3)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity4));
        scoreDirector.beforeEntityRemoved((Object)entity4);
        solution.getEntityList().remove(entity4);
        scoreDirector.afterEntityRemoved((Object)entity4);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @TestTemplate
    public void join_unknownClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEach(TestdataLavishValueGroup.class).join(Integer.class).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void join_0() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishValueGroup valueGroup = new TestdataLavishValueGroup("MyValueGroup");
        solution.getValueGroupList().add(valueGroup);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishValueGroup.class).join(TestdataLavishEntityGroup.class).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstValueGroup(), solution.getFirstEntityGroup()), UniConstraintStreamTest.assertMatch(solution.getFirstValueGroup(), entityGroup), UniConstraintStreamTest.assertMatch(valueGroup, solution.getFirstEntityGroup()), UniConstraintStreamTest.assertMatch(valueGroup, entityGroup));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstValueGroup(), solution.getFirstEntityGroup()), UniConstraintStreamTest.assertMatch(valueGroup, solution.getFirstEntityGroup()));
    }

    @Override
    @TestTemplate
    public void join_1Equal() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity(), solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2), UniConstraintStreamTest.assertMatch(entity1, entity1), UniConstraintStreamTest.assertMatch(entity2, solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity2, entity2));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(entityGroup);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity(), solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1, entity1), UniConstraintStreamTest.assertMatch(entity1, entity2), UniConstraintStreamTest.assertMatch(entity2, entity1), UniConstraintStreamTest.assertMatch(entity2, entity2));
    }

    @Override
    @TestTemplate
    public void join_2Equal() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        entity1.setIntegerProperty(Integer.valueOf(7));
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup, solution.getFirstValue());
        entity2.setIntegerProperty(Integer.valueOf(7));
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", entityGroup, solution.getFirstValue());
        entity3.setIntegerProperty(Integer.valueOf(8));
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup), Joiners.equal(TestdataLavishEntity::getIntegerProperty)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity(), solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1, entity1), UniConstraintStreamTest.assertMatch(entity1, entity2), UniConstraintStreamTest.assertMatch(entity2, entity1), UniConstraintStreamTest.assertMatch(entity2, entity2), UniConstraintStreamTest.assertMatch(entity3, entity3));
        scoreDirector.beforeProblemPropertyChanged((Object)entity1);
        entity1.setIntegerProperty(Integer.valueOf(8));
        scoreDirector.afterProblemPropertyChanged((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity(), solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1, entity1), UniConstraintStreamTest.assertMatch(entity1, entity3), UniConstraintStreamTest.assertMatch(entity2, entity2), UniConstraintStreamTest.assertMatch(entity3, entity1), UniConstraintStreamTest.assertMatch(entity3, entity3));
    }

    @Override
    @TestTemplate
    public void ifExists_unknownClass() {
        this.assumeDrools();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEach(TestdataLavishValueGroup.class).ifExists(Integer.class, new BiJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void ifExists_0Joiner0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishValueGroup valueGroup = new TestdataLavishValueGroup("MyValueGroup");
        solution.getValueGroupList().add(valueGroup);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishValueGroup.class).ifExists(TestdataLavishEntityGroup.class, new BiJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstValueGroup()), UniConstraintStreamTest.assertMatch(valueGroup));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstValueGroup()), UniConstraintStreamTest.assertMatch(valueGroup));
    }

    @Override
    @TestTemplate
    public void ifExists_0Join1Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifExists(TestdataLavishEntityGroup.class, Joiners.filtering((entity, group) -> Objects.equals(entity.getEntityGroup(), group))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity2));
    }

    @Override
    @TestTemplate
    public void ifExists_1Join0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifExists(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity2));
    }

    @Override
    @TestTemplate
    public void ifExists_1Join1Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifExists(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity()), Joiners.filtering((entity, group) -> entity.getCode().contains("MyEntity") || group.getCode().contains("MyEntity"))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity2));
    }

    @TestTemplate
    public void ifExistsOther_1Join0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifExistsOther(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity2));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(entityGroup);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
    }

    @Override
    @TestTemplate
    public void ifExistsDoesNotIncludeNullVars() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("Entity with null var", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifExistsOther(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity2));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(entityGroup);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
    }

    @Override
    @TestTemplate
    public void ifExistsIncludesNullVarsWithFrom() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("Entity with null var", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.from(TestdataLavishEntity.class).ifExistsOther(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity2));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(entityGroup);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
    }

    @Override
    @TestTemplate
    public void ifNotExists_unknownClass() {
        this.assumeDrools();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEach(TestdataLavishValueGroup.class).ifNotExists(Integer.class, new BiJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void ifNotExists_0Joiner0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishValueGroup valueGroup = new TestdataLavishValueGroup("MyValueGroup");
        solution.getValueGroupList().add(valueGroup);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishValueGroup.class).ifNotExists(TestdataLavishEntityGroup.class, new BiJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifNotExists_0Join1Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifNotExists(TestdataLavishEntityGroup.class, Joiners.filtering((entity, group) -> Objects.equals(entity.getEntityGroup(), group))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1));
    }

    @Override
    @TestTemplate
    public void ifNotExists_1Join0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifNotExists(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1));
    }

    @Override
    @TestTemplate
    public void ifNotExists_1Join1Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifNotExists(TestdataLavishEntityGroup.class, Joiners.equal(TestdataLavishEntity::getEntityGroup, Function.identity()), Joiners.filtering((entity, group) -> entity.getCode().contains("MyEntity") || group.getCode().contains("MyEntity"))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1));
    }

    @Override
    @TestTemplate
    public void ifNotExistsDoesNotIncludeNullVars() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("Entity with null var", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifNotExistsOther(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(entityGroup);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()), UniConstraintStreamTest.assertMatch(entity1));
    }

    @Override
    @TestTemplate
    public void ifNotExistsIncludesNullVarsWithFrom() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("Entity with null var", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.from(TestdataLavishEntity.class).ifNotExistsOther(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(entityGroup);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()));
    }

    @TestTemplate
    public void ifNotExistsOther_1Join0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).ifNotExistsOther(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(entityGroup);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(solution.getFirstEntity()));
    }

    @TestTemplate
    public void forEach_unknownClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEach(Integer.class).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @TestTemplate
    public void forEachUniquePair_0() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)0);
        TestdataLavishEntity entityB = new TestdataLavishEntity("B", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entityB);
        TestdataLavishEntity entityA = new TestdataLavishEntity("A", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entityA);
        TestdataLavishEntity entityC = new TestdataLavishEntity("C", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entityC);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entityA, entityB), UniConstraintStreamTest.assertMatch(entityA, entityC), UniConstraintStreamTest.assertMatch(entityB, entityC));
    }

    @TestTemplate
    public void forEachUniquePair_1Equals() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)0);
        TestdataLavishEntity entityB = new TestdataLavishEntity("B", solution.getFirstEntityGroup(), solution.getFirstValue());
        entityB.setIntegerProperty(Integer.valueOf(2));
        solution.getEntityList().add(entityB);
        TestdataLavishEntity entityA = new TestdataLavishEntity("A", solution.getFirstEntityGroup(), solution.getFirstValue());
        entityA.setIntegerProperty(Integer.valueOf(2));
        solution.getEntityList().add(entityA);
        TestdataLavishEntity entityC = new TestdataLavishEntity("C", solution.getFirstEntityGroup(), solution.getFirstValue());
        entityC.setIntegerProperty(Integer.valueOf(10));
        solution.getEntityList().add(entityC);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getIntegerProperty)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entityA, entityB));
        scoreDirector.beforeProblemPropertyChanged((Object)entityB);
        entityB.setIntegerProperty(Integer.valueOf(10));
        scoreDirector.afterProblemPropertyChanged((Object)entityB);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entityB, entityC));
    }

    @TestTemplate
    public void groupBy_1Mapping0Collect_filtered() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup).filter(entityGroup -> Objects.equals(entityGroup, entityGroup1)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1));
    }

    @TestTemplate
    public void groupBy_1Mapping1Collect_filtered() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, ConstraintCollectors.count()).filter((entityGroup, count) -> count > 1).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, 2), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), 8));
    }

    @TestTemplate
    public void groupBy_joinedAndFiltered() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup).join(TestdataLavishEntity.class, Joiners.equal(Function.identity(), TestdataLavishEntity::getEntityGroup)).filter((group, entity) -> group.equals(entityGroup1)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, entity1), UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, entity2));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping0Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup()), UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1));
        Stream.of(entity1, entity2).forEach(entity -> {
            scoreDirector.beforeEntityRemoved(entity);
            solution.getEntityList().remove(entity);
            scoreDirector.afterEntityRemoved(entity);
        });
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup()));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping1Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), 2), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getEntityGroupList().get(1), 1));
        Stream.of((TestdataLavishEntity)solution.getEntityList().get(0), (TestdataLavishEntity)solution.getEntityList().get(1)).forEach(entity -> {
            scoreDirector.beforeEntityRemoved(entity);
            solution.getEntityList().remove(entity);
            scoreDirector.afterEntityRemoved(entity);
        });
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), 1));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping2Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, ConstraintCollectors.count(), ConstraintCollectors.toSet()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), 2, UniConstraintStreamTest.asSet(entity1, entity3)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getEntityGroupList().get(1), 1, Collections.singleton(entity2)));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), 1, Collections.singleton(entity3)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getEntityGroupList().get(1), 1, Collections.singleton(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping3Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, ConstraintCollectors.count(), ConstraintCollectors.countDistinct(), ConstraintCollectors.toSet()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), 2, 2, UniConstraintStreamTest.asSet(entity1, entity3)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getEntityGroupList().get(1), 1, 1, Collections.singleton(entity2)));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), 1, 1, Collections.singleton(entity3)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getEntityGroupList().get(1), 1, 1, Collections.singleton(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping1Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE, count -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-10, 10));
        scoreDirector.beforeEntityRemoved((Object)entity3);
        solution.getEntityList().remove(entity3);
        scoreDirector.afterEntityRemoved((Object)entity3);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-9, 9));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping2Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(ConstraintCollectors.count(), ConstraintCollectors.countDistinct()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, 3, 3));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, 2, 2));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping3Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(ConstraintCollectors.count(), ConstraintCollectors.min(TestdataLavishEntity::getIntegerProperty), ConstraintCollectors.max(TestdataLavishEntity::getIntegerProperty)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setIntegerProperty(Integer.valueOf(0));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setIntegerProperty(Integer.valueOf(1));
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        entity3.setIntegerProperty(Integer.valueOf(2));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, 3, 0, 2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, 2, 1, 2));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping4Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(ConstraintCollectors.count(), ConstraintCollectors.min(TestdataLavishEntity::getIntegerProperty), ConstraintCollectors.max(TestdataLavishEntity::getIntegerProperty), ConstraintCollectors.toSet()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setIntegerProperty(Integer.valueOf(0));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setIntegerProperty(Integer.valueOf(1));
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        entity3.setIntegerProperty(Integer.valueOf(2));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, 3, 0, 2, UniConstraintStreamTest.asSet(entity1, entity2, entity3)));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, 2, 1, 2, UniConstraintStreamTest.asSet(entity2, entity3)));
    }

    @TestTemplate
    public void groupBy_1Mapping1Collector_groupingOnPrimitives() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        entity1.setIntegerProperty(Integer.valueOf(1));
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        entity2.setIntegerProperty(Integer.valueOf(2));
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        entity3.setIntegerProperty(Integer.valueOf(3));
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getIntegerProperty, ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE, (integerProperty, count) -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-8, 1, 8), UniConstraintStreamTest.assertMatchWithScore(-1, 2, 1), UniConstraintStreamTest.assertMatchWithScore(-1, 3, 1));
        scoreDirector.beforeEntityRemoved((Object)entity3);
        solution.getEntityList().remove(entity3);
        scoreDirector.afterEntityRemoved((Object)entity3);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-8, 1, 8), UniConstraintStreamTest.assertMatchWithScore(-1, 2, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping0Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishValue secondValue = (TestdataLavishValue)solution.getValueList().get(1);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", entityGroup1, secondValue);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, TestdataLavishEntity::getValue).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, solution.getFirstValue()), UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, secondValue), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(0)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(1)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(2)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(3)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(4)));
        scoreDirector.beforeEntityRemoved((Object)entity3);
        solution.getEntityList().remove(entity3);
        scoreDirector.afterEntityRemoved((Object)entity3);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, solution.getFirstValue()), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(0)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(1)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(2)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(3)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(4)));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, solution.getFirstValue()), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(0)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(1)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(2)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(3)), UniConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup(), solution.getValueList().get(4)));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping1Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", entityGroup1, value1);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, TestdataLavishEntity::getValue, ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE, (entityGroup, value, count) -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-7, solution.getFirstEntityGroup(), solution.getFirstValue(), 7), UniConstraintStreamTest.assertMatchWithScore(-2, entityGroup1, value1, 2), UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, solution.getFirstValue(), 1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(solution.getFirstEntityGroup());
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-8, solution.getFirstEntityGroup(), solution.getFirstValue(), 8), UniConstraintStreamTest.assertMatchWithScore(-2, entityGroup1, value1, 2));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping2Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", entityGroup1, value1);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, TestdataLavishEntity::getValue, ConstraintCollectors.count(), ConstraintCollectors.count()).penalize("testConstraintName", (Score)SimpleScore.ONE, (entityGroup, value, count, sameCount) -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-7, solution.getFirstEntityGroup(), solution.getFirstValue(), 7, 7), UniConstraintStreamTest.assertMatchWithScore(-2, entityGroup1, value1, 2, 2), UniConstraintStreamTest.assertMatchWithScore(-1, entityGroup1, solution.getFirstValue(), 1, 1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setEntityGroup(solution.getFirstEntityGroup());
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-8, solution.getFirstEntityGroup(), solution.getFirstValue(), 8, 8), UniConstraintStreamTest.assertMatchWithScore(-2, entityGroup1, value1, 2, 2));
    }

    @Override
    @TestTemplate
    public void groupBy_3Mapping0Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)3, (int)2, (int)5);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, TestdataLavishEntity::getValue, TestdataObject::getCode).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntity entity4 = (TestdataLavishEntity)solution.getEntityList().get(3);
        TestdataLavishEntity entity5 = (TestdataLavishEntity)solution.getEntityList().get(4);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        TestdataLavishValue value3 = (TestdataLavishValue)solution.getValueList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, group1, value1, entity1.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, group2, value2, entity2.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, group1, value3, entity3.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, group2, value1, entity4.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, group1, value2, entity5.getCode()));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, group2, value2, entity2.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, group1, value3, entity3.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, group2, value1, entity4.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, group1, value2, entity5.getCode()));
    }

    @Override
    @TestTemplate
    public void groupBy_3Mapping1Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)3, (int)2, (int)5);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup, TestdataLavishEntity::getValue, TestdataObject::getCode, ConstraintCollectors.toSet()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntity entity4 = (TestdataLavishEntity)solution.getEntityList().get(3);
        TestdataLavishEntity entity5 = (TestdataLavishEntity)solution.getEntityList().get(4);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        TestdataLavishValue value3 = (TestdataLavishValue)solution.getValueList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, group1, value1, entity1.getCode(), Collections.singleton(entity1)), UniConstraintStreamTest.assertMatchWithScore(-1, group2, value2, entity2.getCode(), Collections.singleton(entity2)), UniConstraintStreamTest.assertMatchWithScore(-1, group1, value3, entity3.getCode(), Collections.singleton(entity3)), UniConstraintStreamTest.assertMatchWithScore(-1, group2, value1, entity4.getCode(), Collections.singleton(entity4)), UniConstraintStreamTest.assertMatchWithScore(-1, group1, value2, entity5.getCode(), Collections.singleton(entity5)));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, group2, value2, entity2.getCode(), Collections.singleton(entity2)), UniConstraintStreamTest.assertMatchWithScore(-1, group1, value3, entity3.getCode(), Collections.singleton(entity3)), UniConstraintStreamTest.assertMatchWithScore(-1, group2, value1, entity4.getCode(), Collections.singleton(entity4)), UniConstraintStreamTest.assertMatchWithScore(-1, group1, value2, entity5.getCode(), Collections.singleton(entity5)));
    }

    @Override
    @TestTemplate
    public void groupBy_4Mapping0Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)3, (int)2, (int)5);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).groupBy(Function.identity(), TestdataLavishEntity::getEntityGroup, TestdataLavishEntity::getValue, TestdataObject::getCode).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntity entity4 = (TestdataLavishEntity)solution.getEntityList().get(3);
        TestdataLavishEntity entity5 = (TestdataLavishEntity)solution.getEntityList().get(4);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishValue value1 = solution.getFirstValue();
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        TestdataLavishValue value3 = (TestdataLavishValue)solution.getValueList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, entity1, group1, value1, entity1.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, entity2, group2, value2, entity2.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, entity3, group1, value3, entity3.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, entity4, group2, value1, entity4.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, entity5, group1, value2, entity5.getCode()));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatchWithScore(-1, entity2, group2, value2, entity2.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, entity3, group1, value3, entity3.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, entity4, group2, value1, entity4.getCode()), UniConstraintStreamTest.assertMatchWithScore(-1, entity5, group1, value2, entity5.getCode()));
    }

    @Override
    @TestTemplate
    public void distinct() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(entity1), UniConstraintStreamTest.assertMatch(entity2));
    }

    @Override
    @TestTemplate
    public void mapWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).map(TestdataLavishEntity::getEntityGroup).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group = solution.getFirstEntityGroup();
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group), UniConstraintStreamTest.assertMatch(group));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group));
    }

    @Override
    @TestTemplate
    public void mapWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).map(TestdataLavishEntity::getEntityGroup).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group2));
    }

    @Override
    @TestTemplate
    public void mapAndDistinctWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).map(TestdataLavishEntity::getEntityGroup).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group = solution.getFirstEntityGroup();
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group));
    }

    @Override
    @TestTemplate
    public void mapAndDistinctWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).map(TestdataLavishEntity::getEntityGroup).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group2));
    }

    @Override
    @TestTemplate
    public void flattenLastWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).flattenLast(entity -> Arrays.asList(group1, group1, group2)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2), UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2));
    }

    @Override
    @TestTemplate
    public void flattenLastWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).flattenLast(entity -> Collections.singletonList(entity.getEntityGroup())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group2));
    }

    @Override
    @TestTemplate
    public void flattenLastAndDistinctWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)2);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).flattenLast(entity -> Arrays.asList(group1, group1, group2)).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2));
    }

    @Override
    @TestTemplate
    public void flattenLastAndDistinctWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).flattenLast(entity -> Collections.singletonList(entity.getEntityGroup())).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group1), UniConstraintStreamTest.assertMatch(group2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch(group2));
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalize_Int() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalize_Long() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalize_BigDecimal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void penalize_negative() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        String constraintName = "myConstraint1";
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).penalize(constraintName, (Score)SimpleScore.ONE, e -> -1));
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThatThrownBy(() -> scoreDirector.calculateScore()).hasMessageContaining(constraintName);
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void reward_Int() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void reward_Long() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void reward_BigDecimal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void reward_negative() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        String constraintName = "myConstraint1";
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).reward(constraintName, (Score)SimpleScore.ONE, e -> -1));
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThatThrownBy(() -> scoreDirector.calculateScore()).hasMessageContaining(constraintName);
    }

    /*
     * Exception decompiling
     */
    @TestTemplate
    public void duplicateConstraintId() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @TestTemplate
    public void zeroConstraintWeightDisabled() {
        this.assumeBavet();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)3, (int)2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), solution.getFirstValue());
        entity1.setStringProperty("myProperty1");
        solution.getEntityList().add(entity1);
        AtomicLong zeroWeightMonitorCount = new AtomicLong(0L);
        AtomicLong oneWeightMonitorCount = new AtomicLong(0L);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataLavishSolution.buildSolutionDescriptor(), factory -> new Constraint[]{factory.forEach(TestdataLavishEntity.class).filter(entity -> {
            zeroWeightMonitorCount.getAndIncrement();
            return true;
        }).penalize("myConstraint1", (Score)SimpleScore.ZERO), factory.forEach(TestdataLavishEntity.class).filter(entity -> {
            oneWeightMonitorCount.getAndIncrement();
            return true;
        }).penalize("myConstraint2", (Score)SimpleScore.ONE)});
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((long)zeroWeightMonitorCount.getAndSet(0L)).isEqualTo(0L);
        Assertions.assertThat((long)oneWeightMonitorCount.getAndSet(0L)).isEqualTo(3L);
        scoreDirector.beforeProblemPropertyChanged((Object)entity1);
        entity1.setStringProperty("myProperty2");
        scoreDirector.afterProblemPropertyChanged((Object)entity1);
        scoreDirector.calculateScore();
        Assertions.assertThat((long)zeroWeightMonitorCount.get()).isEqualTo(0L);
        Assertions.assertThat((long)oneWeightMonitorCount.get()).isEqualTo(1L);
    }

    @TestTemplate
    public void nodeSharing() {
        this.assumeBavet();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)3, (int)2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), solution.getFirstValue());
        entity1.setStringProperty("myProperty1");
        solution.getEntityList().add(entity1);
        AtomicLong monitorCount = new AtomicLong(0L);
        Predicate<TestdataLavishEntity> predicate = entity -> {
            monitorCount.getAndIncrement();
            return true;
        };
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataLavishSolution.buildSolutionDescriptor(), factory -> new Constraint[]{factory.forEach(TestdataLavishEntity.class).filter(predicate).penalize("myConstraint1", (Score)SimpleScore.ONE), factory.forEach(TestdataLavishEntity.class).filter(predicate).penalize("myConstraint2", (Score)SimpleScore.ONE)});
        scoreDirector.setWorkingSolution((Object)solution);
        scoreDirector.calculateScore();
        Assertions.assertThat((long)monitorCount.getAndSet(0L)).isEqualTo(3L);
        scoreDirector.beforeProblemPropertyChanged((Object)entity1);
        entity1.setStringProperty("myProperty2");
        scoreDirector.afterProblemPropertyChanged((Object)entity1);
        scoreDirector.calculateScore();
        Assertions.assertThat((long)monitorCount.get()).isEqualTo(1L);
    }

    @TestTemplate
    public void reuseFilteredStream() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)3, (int)2);
        TestdataLavishEntity entity1 = (TestdataLavishEntity)solution.getEntityList().get(0);
        Predicate<TestdataLavishEntity> predicate = entity -> Objects.equals(entity, entity1);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataLavishSolution.buildSolutionDescriptor(), factory -> {
            UniConstraintStream base = factory.forEach(TestdataLavishEntity.class).filter(predicate);
            return new Constraint[]{base.penalize("myConstraint1", (Score)SimpleScore.ONE), base.penalize("myConstraint2", (Score)SimpleScore.ONE)};
        });
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch("myConstraint1", entity1), UniConstraintStreamTest.assertMatch("myConstraint2", entity1));
    }

    @TestTemplate
    public void reuseGroupedStream() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)3, (int)2);
        TestdataLavishEntity entity1 = (TestdataLavishEntity)solution.getEntityList().get(0);
        TestdataLavishEntityGroup entityGroup1 = solution.getFirstEntityGroup();
        entity1.setEntityGroup(entityGroup1);
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntityGroup entityGroup2 = new TestdataLavishEntityGroup("Some Other Group");
        entity2.setEntityGroup(entityGroup2);
        InnerScoreDirector scoreDirector = this.buildScoreDirector(TestdataLavishSolution.buildSolutionDescriptor(), factory -> {
            UniConstraintStream base = factory.forEach(TestdataLavishEntity.class).groupBy(TestdataLavishEntity::getEntityGroup);
            return new Constraint[]{base.penalize("myConstraint1", (Score)SimpleScore.ONE), base.filter(e -> !Objects.equals(e, entityGroup1)).penalize("myConstraint2", (Score)SimpleScore.ONE)};
        });
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, UniConstraintStreamTest.assertMatch("myConstraint1", entityGroup1), UniConstraintStreamTest.assertMatch("myConstraint1", entityGroup2), UniConstraintStreamTest.assertMatch("myConstraint2", entityGroup2));
    }

    /*
     * Exception decompiling
     */
    @TestTemplate
    public void fromIncludesNullWhenNullable() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private /* synthetic */ void lambda$duplicateConstraintId$96(ConstraintProvider constraintProvider) throws Throwable {
        this.buildScoreDirector(TestdataLavishSolution.buildSolutionDescriptor(), constraintProvider);
    }
}

